/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public final class SpringBeanUtils {
    private static final SpringBeanUtils INSTANCE = new SpringBeanUtils();
    private ApplicationContext applicationContext;

    private SpringBeanUtils() {
    }

    public static SpringBeanUtils getInstance() {
        return INSTANCE;
    }

    public <T> T getBean(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    public <T> T getBean(String beanName) {
        return (T)this.applicationContext.getBean(beanName);
    }

    public String registerBean(BeanDefinition beanDefinition, ClassLoader classLoader) {
        String beanClassName = beanDefinition.getBeanClassName();
        if (StringUtils.isBlank((CharSequence)beanClassName)) {
            throw new NullPointerException("beanDefinition.beanClassName is null");
        }
        String beanName = this.getBeanName(beanClassName);
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        beanFactory.setBeanClassLoader(classLoader);
        beanFactory.registerBeanDefinition(beanName, beanDefinition);
        return beanName;
    }

    public boolean existBean(String className) {
        String beanName = this.getBeanName(className);
        return this.applicationContext.containsBean(beanName);
    }

    public <T> T getBeanByClassName(String className) {
        String beanName = this.getBeanName(className);
        try {
            return this.getBean(beanName);
        }
        catch (BeansException e) {
            return null;
        }
    }

    public void destroyBean(String className) {
        String beanName = this.getBeanName(className);
        DefaultListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsBean(beanName)) {
            beanFactory.destroySingleton(beanName);
            beanFactory.removeBeanDefinition(beanName);
        }
    }

    private DefaultListableBeanFactory getBeanFactory() {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
        return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
    }

    private String getBeanName(String className) {
        String name = className.substring(className.lastIndexOf(".") + 1);
        String start = name.substring(0, 1);
        String end = name.substring(1);
        return start.toLowerCase() + end;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

