/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.dynamic.server.definition;

import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DynamicNacosToolDefinition
implements ToolDefinition {
    private String name;
    private String description;
    private String version;
    private String protocol;
    private McpServerRemoteServiceConfig remoteServerConfig;
    private Boolean enabled;
    private Object inputSchema;
    private McpToolMeta toolMeta;

    public DynamicNacosToolDefinition() {
    }

    public DynamicNacosToolDefinition(String name, String description, String inputSchema) {
        Assert.hasText((String)name, (String)"name cannot be null or empty");
        Assert.hasText((String)description, (String)"description cannot be null or empty");
        Assert.hasText((String)inputSchema, (String)"inputSchema cannot be null or empty");
        this.name = name;
        this.description = description;
        this.inputSchema = inputSchema;
    }

    public DynamicNacosToolDefinition(String name, String description, Object inputSchema, String version, String protocol, McpServerRemoteServiceConfig remoteServerConfig, McpToolMeta toolMeta, Boolean enabled) {
        Assert.hasText((String)name, (String)"name cannot be null or empty");
        Assert.hasText((String)description, (String)"description cannot be null or empty");
        Assert.notNull((Object)inputSchema, (String)"inputSchema cannot be null or empty");
        this.name = name;
        this.description = description;
        this.inputSchema = inputSchema;
        this.version = version;
        this.protocol = protocol;
        this.remoteServerConfig = remoteServerConfig;
        this.toolMeta = toolMeta;
        this.enabled = enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String inputSchema() {
        return JacksonUtils.toJson((Object)this.inputSchema);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(Object inputSchema) {
        this.inputSchema = inputSchema;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public McpServerRemoteServiceConfig getRemoteServerConfig() {
        return this.remoteServerConfig;
    }

    public void setRemoteServerConfig(McpServerRemoteServiceConfig remoteServerConfig) {
        this.remoteServerConfig = remoteServerConfig;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public McpToolMeta getToolMeta() {
        return this.toolMeta;
    }

    public void setToolMeta(McpToolMeta toolMeta) {
        this.toolMeta = toolMeta;
    }

    public static final class Builder {
        private String name;
        private String description;
        private String version;
        private String protocol;
        private McpServerRemoteServiceConfig remoteServerConfig;
        private Boolean enabled;
        private Object inputSchema;
        private McpToolMeta toolsMeta;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder remoteServerConfig(McpServerRemoteServiceConfig remoteServerConfig) {
            this.remoteServerConfig = remoteServerConfig;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder inputSchema(Object inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public Builder toolsMeta(McpToolMeta toolsMeta) {
            this.toolsMeta = toolsMeta;
            return this;
        }

        public DynamicNacosToolDefinition build() {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.description})) {
                this.description = ToolUtils.getToolDescriptionFromName((String)this.name);
            }
            return new DynamicNacosToolDefinition(this.name, this.description, this.inputSchema, this.version, this.protocol, this.remoteServerConfig, this.toolsMeta, this.enabled);
        }
    }
}

