/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.server;

import com.alibaba.cloud.ai.autoconfigure.mcp.server.NacosMcpRegistryAutoConfiguration;
import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.config.NacosMcpDynamicProperties;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.properties.McpDynamicServerProperties;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.provider.DynamicMcpAsyncToolsProvider;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.provider.DynamicMcpSyncToolsProvider;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.provider.DynamicMcpToolsProvider;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.provider.DynamicToolCallbackProvider;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.tools.DynamicToolsInitializer;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.utils.SpringBeanUtils;
import com.alibaba.cloud.ai.mcp.nacos.dynamic.server.watcher.DynamicNacosToolsWatcher;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.exception.NacosException;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

@EnableConfigurationProperties(value={McpDynamicServerProperties.class, NacosMcpProperties.class, NacosMcpDynamicProperties.class, McpServerProperties.class})
@AutoConfiguration(after={McpServerAutoConfiguration.class, NacosMcpRegistryAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class NacosDynamicMcpServerAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosDynamicMcpServerAutoConfiguration.class);
    @Resource
    private McpDynamicServerProperties mcpDynamicServerProperties;
    @Resource
    private NacosMcpProperties nacosMcpProperties;
    @Resource
    private NacosMcpDynamicProperties nacosMcpDynamicProperties;

    @Bean
    @ConditionalOnMissingBean(value={NacosMcpOperationService.class})
    public NacosMcpOperationService nacosMcpOperationService() {
        Properties nacosProperties = this.nacosMcpProperties.getNacosProperties();
        try {
            return new NacosMcpOperationService(nacosProperties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        SpringBeanUtils.getInstance().setApplicationContext(applicationContext);
    }

    @Bean
    public ToolCallbackProvider callbackProvider(DynamicToolsInitializer toolsInitializer) {
        return DynamicToolCallbackProvider.builder().toolCallbacks(toolsInitializer.initializeTools()).build();
    }

    @Bean
    public DynamicToolsInitializer dynamicToolsInitializer(NacosMcpOperationService nacosMcpOperationService) {
        return new DynamicToolsInitializer(nacosMcpOperationService, this.nacosMcpDynamicProperties);
    }

    @Bean(destroyMethod="stop")
    public DynamicNacosToolsWatcher nacosInstanceWatcher(DynamicMcpToolsProvider dynamicMcpToolsProvider, NacosMcpOperationService nacosMcpOperationService) {
        return new DynamicNacosToolsWatcher(this.nacosMcpDynamicProperties, nacosMcpOperationService, dynamicMcpToolsProvider);
    }

    @Bean
    @ConditionalOnBean(value={McpAsyncServer.class})
    @ConditionalOnMissingBean(value={DynamicMcpToolsProvider.class})
    public DynamicMcpToolsProvider dynamicMcpAsyncToolsProvider(McpAsyncServer mcpAsyncServer) {
        return new DynamicMcpAsyncToolsProvider(mcpAsyncServer);
    }

    @Bean
    @ConditionalOnBean(value={McpSyncServer.class})
    @ConditionalOnMissingBean(value={DynamicMcpToolsProvider.class})
    public DynamicMcpToolsProvider dynamicMcpSyncToolsProvider(McpSyncServer mcpSyncServer) {
        return new DynamicMcpSyncToolsProvider(mcpSyncServer);
    }

    @Bean
    public WebClient webClient() {
        ConnectionProvider provider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"http-pool").maxConnections(this.mcpDynamicServerProperties.getMaxConnections())).pendingAcquireTimeout(Duration.ofMillis(this.mcpDynamicServerProperties.getAcquireTimeout()))).maxIdleTime(Duration.ofSeconds(this.mcpDynamicServerProperties.getMaxIdleTime()))).maxLifeTime(Duration.ofSeconds(this.mcpDynamicServerProperties.getMaxLifeTime()))).build();
        HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)provider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.mcpDynamicServerProperties.getConnectionTimeout())).responseTimeout(Duration.ofMillis(this.mcpDynamicServerProperties.getReadTimeout())).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)this.mcpDynamicServerProperties.getReadTimeout(), TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)this.mcpDynamicServerProperties.getWriteTimeout(), TimeUnit.MILLISECONDS)));
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).filter(this.logRequest()).filter(this.logResponse()).build();
    }

    private ExchangeFilterFunction logRequest() {
        Logger logger = LoggerFactory.getLogger(WebClient.class);
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            logger.info("Request: {} {}", (Object)clientRequest.method(), (Object)clientRequest.url());
            clientRequest.headers().forEach((name, values) -> values.forEach(value -> log.debug("Request Header: {}={}", name, value)));
            return Mono.just((Object)clientRequest);
        });
    }

    private ExchangeFilterFunction logResponse() {
        Logger logger = LoggerFactory.getLogger(WebClient.class);
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            logger.info("Response Status: {}", (Object)clientResponse.statusCode());
            clientResponse.headers().asHttpHeaders().forEach((name, values) -> values.forEach(value -> log.debug("Response Header: {}={}", name, value)));
            return Mono.just((Object)clientResponse);
        });
    }
}

