/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.a2a.utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InetUtils.class);

    public static InetAddress findFirstNonLoopbackIpv4Address() {
        return InetUtils.findFirstNonLoopbackAddress(inetAddress -> inetAddress instanceof Inet4Address);
    }

    public static InetAddress findFirstNonLoopbackIpv6Address() {
        return InetUtils.findFirstNonLoopbackAddress(inetAddress -> inetAddress instanceof Inet6Address);
    }

    private static InetAddress findFirstNonLoopbackAddress(Function<InetAddress, Boolean> typeFilter) {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                LOGGER.trace("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!typeFilter.apply(address).booleanValue() || address.isLoopbackAddress()) continue;
                    LOGGER.trace("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to retrieve localhost");
            return null;
        }
    }
}

