/*
 * Decompiled with CFR 0.152.
 */
package com.alexkasko.installer;

import com.alexkasko.installer.SettingsMojo;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.izforge.izpack.compiler.CompilerConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.UnhandledException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.core.io.Resource;
import ru.concerteza.util.archive.TarFunction;
import ru.concerteza.util.archive.ZipFunction;
import ru.concerteza.util.collection.CtzCollectionUtils;
import ru.concerteza.util.freemarker.FreemarkerEngine;
import ru.concerteza.util.io.CtzCopyCheckLMUtils;
import ru.concerteza.util.io.CtzIOUtils;
import ru.concerteza.util.io.CtzResourceUtils;

public class InstallerMojo
extends SettingsMojo {
    private final FreemarkerEngine freemarker = new FreemarkerEngine();
    private final MarkExecutableFunction markExecutableFunction = new MarkExecutableFunction();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Dirs dirs = this.prepareDirs();
            this.copyBin(dirs.bin);
            this.copyIzpack();
            this.copyUninstall(dirs.uninstall);
            this.copyPrunsrv(dirs.bin);
            this.copyAppData();
            this.markBinExecutable(dirs.bin);
            this.copyLibs(dirs.lib);
            this.copyLauncher(dirs.bin);
            File jre = this.copyJRE();
            this.copyIzPackResources();
            this.runIzPackCompiler();
            this.packInstaller(jre);
            if (this.buildUnixDist) {
                this.packDist();
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("IzPack error", (Throwable)e);
        }
    }

    private Dirs prepareDirs() throws IOException {
        CtzIOUtils.mkdirs((File)this.izpackDir);
        CtzIOUtils.mkdirs((File)this.distDir);
        File bin = CtzIOUtils.mkdirs((File)new File(this.distDir, "bin"));
        File lib = CtzIOUtils.mkdirs((File)new File(this.distDir, "lib"));
        File uninstall = CtzIOUtils.mkdirs((File)new File(this.distDir, "uninstall"));
        CtzIOUtils.mkdirs((File)new File(this.distDir, "temp"));
        CtzIOUtils.mkdirs((File)new File(this.distDir, this.prunsrvLogPath));
        return new Dirs(bin, lib, uninstall);
    }

    private void copyBin(File binDir) throws IOException {
        Resource[] resources = CtzResourceUtils.RESOURCE_RESOLVER.getResources("classpath:/bin/*");
        List<Resource> list = Arrays.asList(resources);
        List copied = Lists.transform(list, (Function)new FtlCopyFunction(binDir));
        CtzCollectionUtils.fireTransform((Iterable)copied);
        File daemonDir = new File(binDir, "java-daemon");
        Resource[] daemon = CtzResourceUtils.RESOURCE_RESOLVER.getResources("classpath:/bin/java-daemon/*");
        List<Resource> daemonList = Arrays.asList(daemon);
        List daemonCopied = Lists.transform(daemonList, (Function)new CopyFunction(daemonDir));
        CtzCollectionUtils.fireTransform((Iterable)daemonCopied);
    }

    private void copyIzpack() throws IOException {
        Resource[] resources = CtzResourceUtils.RESOURCE_RESOLVER.getResources("classpath:/izpack/*");
        List<Resource> list = Arrays.asList(resources);
        List copied = Lists.transform(list, (Function)new FtlCopyFunction(this.izpackDir));
        CtzCollectionUtils.fireTransform((Iterable)copied);
        FileUtils.writeStringToFile((File)new File(this.izpackDir, "default-install-dir.txt"), (String)this.izpackDefaultInstallDir, (String)"UTF-8");
    }

    private void copyUninstall(File uninstallDir) {
        if (this.use64BitJre && !this.useX86LaunchersForX64Installer) {
            CtzResourceUtils.copyResourceToDir((String)this.installLauncher64Path, (File)this.izpackDir);
            CtzResourceUtils.copyResourceToDir((String)this.uninstallLauncher64Path, (File)uninstallDir);
        } else {
            CtzResourceUtils.copyResourceToDir((String)this.installLauncher32Path, (File)this.izpackDir);
            CtzResourceUtils.copyResourceToDir((String)this.uninstallLauncher32Path, (File)uninstallDir);
        }
    }

    private void copyPrunsrv(File binDir) throws IOException {
        Resource[] resources = CtzResourceUtils.RESOURCE_RESOLVER.getResources("classpath:/prunsrv/*");
        List<Resource> list = Arrays.asList(resources);
        Predicate notExe = Predicates.not((Predicate)new PostfixPredicate(".exe"));
        Iterable filtered = Iterables.filter(list, (Predicate)notExe);
        Iterable copied = Iterables.transform((Iterable)filtered, (Function)new FtlCopyFunction(binDir, this.prunsrvScriptsEncoding));
        CtzCollectionUtils.fireTransform((Iterable)copied);
        String prunsrvPath = this.use64BitJre ? "classpath:/prunsrv/prunsrv_x86_64.exe" : "classpath:/prunsrv/prunsrv_x86_32.exe";
        File prunsrvTarget = new File(binDir, "prunsrv.exe");
        CtzResourceUtils.copyResource((String)prunsrvPath, (File)prunsrvTarget);
    }

    private void copyAppData() throws IOException {
        for (String dir : this.appDataDirs) {
            File source = new File(dir);
            CtzCopyCheckLMUtils.copyDirectoryToDirectory((File)source, (File)this.distDir);
        }
    }

    private void markBinExecutable(File binDir) {
        List files = CtzIOUtils.listFiles((File)binDir, (IOFileFilter)new SuffixFileFilter(".sh"), (boolean)false);
        List marked = Lists.transform((List)files, (Function)this.markExecutableFunction);
        CtzCollectionUtils.fireTransform((Iterable)marked);
    }

    private void copyLibs(File libDir) throws IOException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact ar : artifacts) {
            CtzCopyCheckLMUtils.copyFileToDirectory((File)ar.getFile(), (File)libDir);
        }
    }

    private void copyLauncher(File binDir) throws IOException {
        File dest = new File(binDir, this.prunsrvLauncherJarFile);
        File launcher = null == this.project.getArtifact().getFile() ? new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar") : this.project.getArtifact().getFile();
        CtzCopyCheckLMUtils.copyFile((File)launcher, (File)dest);
    }

    private File copyJRE() throws IOException {
        File innerJre = new File(this.izpackDir, "jre");
        CtzCopyCheckLMUtils.copyDirectory((File)this.jreDir, (File)innerJre);
        return innerJre;
    }

    private void copyIzPackResources() {
        CtzResourceUtils.copyResourceToDir((String)this.izpackFrameIconPath, (File)this.izpackDir);
        CtzResourceUtils.copyResourceToDir((String)this.izpackHelloIconPath, (File)this.izpackDir);
        File lpdir = new File(this.izpackDir, "bin/langpacks/installer");
        File flagdir = new File(this.izpackDir, "bin/langpacks/flags");
        CtzResourceUtils.copyResourceToDir((String)"classpath:/izpack/xxx.xml", (File)lpdir);
        CtzResourceUtils.copyResourceToDir((String)"classpath:/izpack/xxx.gif", (File)flagdir);
        if (null != this.izpackAdditionalResourcePaths) {
            File addres = new File(this.izpackDir, "addres");
            for (String re : this.izpackAdditionalResourcePaths) {
                CtzResourceUtils.copyResourceToDir((String)re, (File)addres);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIzPackCompiler() throws Exception {
        PrintStream console = System.out;
        try {
            PrintStream ps = new PrintStream((OutputStream)FileUtils.openOutputStream((File)this.buildOutputFile), true, "UTF-8");
            System.setOut(ps);
            File installFile = null != this.installConfigFile ? this.installConfigFile : new File(this.izpackDir, "izpack.xml");
            CompilerConfig compilerConfig = new CompilerConfig(installFile.getAbsolutePath(), this.izpackDir.getAbsolutePath(), "standard", this.izpackOutputFile.getAbsolutePath(), this.izpackCompress, null);
            CompilerConfig.setIzpackHome((String)this.izpackDir.getAbsolutePath());
            compilerConfig.executeCompiler();
        }
        finally {
            System.setOut(console);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packInstaller(File jre) throws IOException {
        ZipOutputStream zip = null;
        InputStream resStream = null;
        try {
            FileOutputStream out = FileUtils.openOutputStream((File)this.installerOutputFile);
            String prefix = FilenameUtils.getBaseName((String)this.installerOutputFile.getPath());
            zip = new ZipOutputStream(out);
            zip.putNextEntry(new ZipEntry(prefix + "/install.jar"));
            FileUtils.copyFile((File)this.izpackOutputFile, (OutputStream)zip);
            zip.putNextEntry(new ZipEntry(prefix + "/install.exe"));
            resStream = this.use64BitJre && !this.useX86LaunchersForX64Installer ? CtzResourceUtils.RESOURCE_LOADER.getResource(this.installLauncher64Path).getInputStream() : CtzResourceUtils.RESOURCE_LOADER.getResource(this.installLauncher32Path).getInputStream();
            IOUtils.copyLarge((InputStream)resStream, (OutputStream)zip);
            ZipFunction zipper = new ZipFunction(jre, prefix + "/jre", zip);
            List files = CtzIOUtils.listFiles((File)jre, (boolean)true);
            Collection zipped = Collections2.transform((Collection)files, (Function)zipper);
            CtzCollectionUtils.fireTransform((Iterable)zipped);
            this.getLog().info((CharSequence)("Installer written to: [" + this.installerOutputFile.getPath() + "]"));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zip);
            IOUtils.closeQuietly(resStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zip);
        IOUtils.closeQuietly((InputStream)resStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packDist() throws IOException {
        TarArchiveOutputStream tar = null;
        try {
            FileOutputStream out = FileUtils.openOutputStream((File)this.distOutputFile);
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            String prefix = FilenameUtils.getBaseName((String)this.distOutputFile.getPath());
            tar = new TarArchiveOutputStream((OutputStream)gzip);
            TarFunction tarfun = new TarFunction(this.distDir, prefix, tar);
            NotFileFilter uninstallFilter = new NotFileFilter((IOFileFilter)new NameFileFilter("uninstall"));
            List files = CtzIOUtils.listFiles((File)this.distDir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)uninstallFilter, (boolean)true);
            Collection tarred = Collections2.transform((Collection)files, (Function)tarfun);
            CtzCollectionUtils.fireTransform((Iterable)tarred);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(tar);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)tar);
    }

    private class Dirs {
        private final File bin;
        private final File lib;
        private final File uninstall;

        private Dirs(File bin, File lib, File uninstall) {
            this.bin = bin;
            this.lib = lib;
            this.uninstall = uninstall;
        }
    }

    private class PostfixPredicate
    implements Predicate<Resource> {
        private final String postfix;

        private PostfixPredicate(String postfix) {
            this.postfix = postfix;
        }

        public boolean apply(Resource input) {
            return CtzResourceUtils.path((Resource)input).endsWith(this.postfix);
        }
    }

    private class MarkExecutableFunction
    implements Function<File, Boolean> {
        private MarkExecutableFunction() {
        }

        public Boolean apply(File input) {
            return input.setExecutable(true);
        }
    }

    private class FtlCopyFunction
    extends CopyFunction {
        private final String ftlOutputEncoding;

        private FtlCopyFunction(File dir) {
            this(dir, "UTF-8");
        }

        private FtlCopyFunction(File dir, String ftlOutputEncoding) {
            super(dir);
            this.ftlOutputEncoding = ftlOutputEncoding;
        }

        @Override
        public File apply(Resource input) {
            File file;
            String name = input.getFilename();
            if (name.endsWith(".ftl")) {
                OutputStream out = null;
                try {
                    file = new File(this.dir, name.substring(0, name.length() - 4));
                    FileOutputStream os = FileUtils.openOutputStream((File)file);
                    InstallerMojo.this.freemarker.process(input.getInputStream(), (Object)InstallerMojo.this, (OutputStream)os, this.ftlOutputEncoding);
                }
                catch (IOException e) {
                    throw new UnhandledException((Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(out);
                }
            } else {
                file = super.apply(input);
            }
            return file;
        }
    }

    private class CopyFunction
    implements Function<Resource, File> {
        protected final File dir;

        private CopyFunction(File dir) {
            this.dir = dir;
        }

        public File apply(Resource input) {
            File file = new File(this.dir, input.getFilename());
            return CtzResourceUtils.copyResource((Resource)input, (File)file);
        }
    }
}

