/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.WritePolicy;

public final class OperateArgs {
    public final WritePolicy writePolicy;
    public final Operation[] operations;
    public final Partition partition;
    public final int size;
    public final int readAttr;
    public final int writeAttr;
    public final boolean hasWrite;

    public OperateArgs(Cluster cluster, WritePolicy policy, WritePolicy writeDefault, WritePolicy readDefault, Key key, Operation[] operations) {
        this.operations = operations;
        int dataOffset = 0;
        int rattr = 0;
        int wattr = 0;
        boolean write2 = false;
        boolean readBin = false;
        boolean readHeader = false;
        boolean respondAllOps = false;
        for (Operation operation : operations) {
            switch (operation.type) {
                case BIT_READ: 
                case EXP_READ: 
                case HLL_READ: 
                case MAP_READ: {
                    respondAllOps = true;
                }
                case CDT_READ: 
                case READ: {
                    rattr |= 1;
                    if (operation.binName == null) {
                        rattr |= 2;
                    }
                    readBin = true;
                    break;
                }
                case READ_HEADER: {
                    rattr |= 1;
                    readHeader = true;
                    break;
                }
                case BIT_MODIFY: 
                case EXP_MODIFY: 
                case HLL_MODIFY: 
                case MAP_MODIFY: {
                    respondAllOps = true;
                }
                default: {
                    wattr = 1;
                    write2 = true;
                }
            }
            dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
            dataOffset += operation.value.estimateSize();
        }
        this.size = dataOffset;
        this.hasWrite = write2;
        if (readHeader && !readBin) {
            rattr |= 0x20;
        }
        this.readAttr = rattr;
        this.writePolicy = policy == null ? (write2 ? writeDefault : readDefault) : policy;
        if (respondAllOps || this.writePolicy.respondAllOps) {
            wattr |= 0x80;
        }
        this.writeAttr = wattr;
        this.partition = write2 ? Partition.write(cluster, this.writePolicy, key) : Partition.read(cluster, this.writePolicy, key);
    }
}

