/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Operation;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchReadPolicy;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ReadModeAP;

public final class BatchAttr {
    public Expression filterExp;
    public int readAttr;
    public int writeAttr;
    public int infoAttr;
    public int expiration;
    public short generation;
    public boolean hasWrite;
    public boolean sendKey;

    public BatchAttr() {
    }

    public BatchAttr(Policy policy, int rattr) {
        this.setRead(policy);
        this.readAttr |= rattr;
    }

    public BatchAttr(BatchPolicy rp, BatchWritePolicy wp, Operation[] ops) {
        boolean readAllBins = false;
        boolean readHeader = false;
        boolean hasRead = false;
        boolean hasWriteOp = false;
        block4: for (Operation op : ops) {
            switch (op.type) {
                case BIT_READ: 
                case EXP_READ: 
                case HLL_READ: 
                case MAP_READ: 
                case CDT_READ: 
                case READ: {
                    if (op.binName == null) {
                        readAllBins = true;
                    }
                    hasRead = true;
                    continue block4;
                }
                case READ_HEADER: {
                    readHeader = true;
                    hasRead = true;
                    continue block4;
                }
                default: {
                    hasWriteOp = true;
                }
            }
        }
        if (hasWriteOp) {
            this.setWrite(wp);
            if (hasRead) {
                this.readAttr |= 1;
                if (readAllBins) {
                    this.readAttr |= 2;
                } else if (readHeader) {
                    this.readAttr |= 0x20;
                }
            }
        } else {
            this.setRead(rp);
            if (readAllBins) {
                this.readAttr |= 2;
            } else if (readHeader) {
                this.readAttr |= 0x20;
            }
        }
    }

    public void setRead(Policy rp) {
        this.filterExp = null;
        this.readAttr = 1;
        if (rp.readModeAP == ReadModeAP.ALL) {
            this.readAttr |= 0x40;
        }
        this.writeAttr = 0;
        switch (rp.readModeSC) {
            default: {
                this.infoAttr = 0;
                break;
            }
            case LINEARIZE: {
                this.infoAttr = 64;
                break;
            }
            case ALLOW_REPLICA: {
                this.infoAttr = 128;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                this.infoAttr = 192;
            }
        }
        this.expiration = 0;
        this.generation = 0;
        this.hasWrite = false;
        this.sendKey = false;
    }

    public void setRead(BatchReadPolicy rp) {
        this.filterExp = rp.filterExp;
        this.readAttr = 1;
        if (rp.readModeAP == ReadModeAP.ALL) {
            this.readAttr |= 0x40;
        }
        this.writeAttr = 0;
        switch (rp.readModeSC) {
            default: {
                this.infoAttr = 0;
                break;
            }
            case LINEARIZE: {
                this.infoAttr = 64;
                break;
            }
            case ALLOW_REPLICA: {
                this.infoAttr = 128;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                this.infoAttr = 192;
            }
        }
        this.expiration = 0;
        this.generation = 0;
        this.hasWrite = false;
        this.sendKey = false;
    }

    public void adjustRead(Operation[] ops) {
        boolean readAllBins = false;
        boolean readHeader = false;
        block4: for (Operation op : ops) {
            switch (op.type) {
                case BIT_READ: 
                case EXP_READ: 
                case HLL_READ: 
                case MAP_READ: 
                case CDT_READ: 
                case READ: {
                    if (op.binName != null) continue block4;
                    readAllBins = true;
                    continue block4;
                }
                case READ_HEADER: {
                    readHeader = true;
                    continue block4;
                }
            }
        }
        if (readAllBins) {
            this.readAttr |= 2;
        } else if (readHeader) {
            this.readAttr |= 0x20;
        }
    }

    public void adjustRead(boolean readAllBins) {
        this.readAttr = readAllBins ? (this.readAttr |= 2) : (this.readAttr |= 0x20);
    }

    public void setWrite(Policy wp) {
        this.filterExp = null;
        this.readAttr = 0;
        this.writeAttr = 129;
        this.infoAttr = 0;
        this.expiration = 0;
        this.generation = 0;
        this.hasWrite = true;
        this.sendKey = wp.sendKey;
    }

    public void setWrite(BatchWritePolicy wp) {
        this.filterExp = wp.filterExp;
        this.readAttr = 0;
        this.writeAttr = 129;
        this.infoAttr = 0;
        this.expiration = wp.expiration;
        this.hasWrite = true;
        this.sendKey = wp.sendKey;
        switch (wp.generationPolicy) {
            default: {
                this.generation = 0;
                break;
            }
            case EXPECT_GEN_EQUAL: {
                this.generation = (short)wp.generation;
                this.writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                this.generation = (short)wp.generation;
                this.writeAttr |= 8;
            }
        }
        switch (wp.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                this.infoAttr |= 8;
                break;
            }
            case REPLACE: {
                this.infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                this.infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                this.writeAttr |= 0x20;
            }
        }
        if (wp.durableDelete) {
            this.writeAttr |= 0x10;
        }
        if (wp.commitLevel == CommitLevel.COMMIT_MASTER) {
            this.infoAttr |= 2;
        }
    }

    public void adjustWrite(Operation[] ops) {
        boolean readAllBins = false;
        boolean readHeader = false;
        boolean hasRead = false;
        block4: for (Operation op : ops) {
            switch (op.type) {
                case BIT_READ: 
                case EXP_READ: 
                case HLL_READ: 
                case MAP_READ: 
                case CDT_READ: 
                case READ: {
                    if (op.binName == null) {
                        readAllBins = true;
                    }
                    hasRead = true;
                    continue block4;
                }
                case READ_HEADER: {
                    readHeader = true;
                    hasRead = true;
                    continue block4;
                }
            }
        }
        if (hasRead) {
            this.readAttr |= 1;
            if (readAllBins) {
                this.readAttr |= 2;
            } else if (readHeader) {
                this.readAttr |= 0x20;
            }
        }
    }

    public void setUDF(Policy up) {
        this.filterExp = null;
        this.readAttr = 0;
        this.writeAttr = 1;
        this.infoAttr = 0;
        this.expiration = 0;
        this.generation = 0;
        this.hasWrite = true;
        this.sendKey = up.sendKey;
    }

    public void setUDF(BatchUDFPolicy up) {
        this.filterExp = up.filterExp;
        this.readAttr = 0;
        this.writeAttr = 1;
        this.infoAttr = 0;
        this.expiration = up.expiration;
        this.generation = 0;
        this.hasWrite = true;
        this.sendKey = up.sendKey;
        if (up.durableDelete) {
            this.writeAttr |= 0x10;
        }
        if (up.commitLevel == CommitLevel.COMMIT_MASTER) {
            this.infoAttr |= 2;
        }
    }

    public void setDelete(Policy dp) {
        this.filterExp = null;
        this.readAttr = 0;
        this.writeAttr = 131;
        this.infoAttr = 0;
        this.expiration = 0;
        this.generation = 0;
        this.hasWrite = true;
        this.sendKey = dp.sendKey;
    }

    public void setDelete(BatchDeletePolicy dp) {
        this.filterExp = dp.filterExp;
        this.readAttr = 0;
        this.writeAttr = 131;
        this.infoAttr = 0;
        this.expiration = 0;
        this.hasWrite = true;
        this.sendKey = dp.sendKey;
        switch (dp.generationPolicy) {
            default: {
                this.generation = 0;
                break;
            }
            case EXPECT_GEN_EQUAL: {
                this.generation = (short)dp.generation;
                this.writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                this.generation = (short)dp.generation;
                this.writeAttr |= 8;
            }
        }
        if (dp.durableDelete) {
            this.writeAttr |= 0x10;
        }
        if (dp.commitLevel == CommitLevel.COMMIT_MASTER) {
            this.infoAttr |= 2;
        }
    }
}

