/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.openbanking;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.openbanking.AccountVerificationReportResponse;
import com.adyen.model.openbanking.AccountVerificationRoutesRequest;
import com.adyen.model.openbanking.AccountVerificationRoutesResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AccountVerificationApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public AccountVerificationApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://obgateway-test.adyen.com/obgateway/v1");
    }

    public AccountVerificationApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public AccountVerificationRoutesResponse createAccountVerificationRoutes(AccountVerificationRoutesRequest accountVerificationRoutesRequest) throws ApiException, IOException {
        return this.createAccountVerificationRoutes(accountVerificationRoutesRequest, null);
    }

    public AccountVerificationRoutesResponse createAccountVerificationRoutes(AccountVerificationRoutesRequest accountVerificationRoutesRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = accountVerificationRoutesRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/accountVerification/routes", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AccountVerificationRoutesResponse.fromJson(jsonResult);
    }

    public AccountVerificationReportResponse getAccountVerificationReport(String code) throws ApiException, IOException {
        return this.getAccountVerificationReport(code, null);
    }

    public AccountVerificationReportResponse getAccountVerificationReport(String code, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (code == null) {
            throw new IllegalArgumentException("Please provide the code path parameter");
        }
        pathParams.put("code", code);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/accountVerification/reports/{code}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AccountVerificationReportResponse.fromJson(jsonResult);
    }
}

