/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"companyAccount", "merchantAccount"})
public class GetStoresUnderAccountRequest {
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;

    public GetStoresUnderAccountRequest companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The company account. If you only specify this parameter, the response includes the stores of all merchant accounts that are associated with the company account.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetStoresUnderAccountRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account. With this parameter, the response only includes the stores of the specified merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStoresUnderAccountRequest getStoresUnderAccountRequest = (GetStoresUnderAccountRequest)o;
        return Objects.equals(this.companyAccount, getStoresUnderAccountRequest.companyAccount) && Objects.equals(this.merchantAccount, getStoresUnderAccountRequest.merchantAccount);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetStoresUnderAccountRequest {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetStoresUnderAccountRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetStoresUnderAccountRequest)JSON.getMapper().readValue(jsonString, GetStoresUnderAccountRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

