/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.CustomerOrderReqType;
import com.adyen.model.nexo.SaleTerminalData;
import com.adyen.model.nexo.SaleToIssuerData;
import com.adyen.model.nexo.SponsoredMerchant;
import com.adyen.model.nexo.TokenRequestedType;
import com.adyen.model.nexo.TransactionIdentification;
import com.adyen.model.terminal.SaleToAcquirerData;
import com.adyen.serializer.SaleToAcquirerDataSerializer;
import com.google.gson.annotations.JsonAdapter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SaleData", propOrder={"saleTransactionID", "saleTerminalData", "sponsoredMerchant", "saleToPOIData", "saleToAcquirerData", "saleToIssuerData"})
public class SaleData {
    @XmlElement(name="SaleTransactionID", required=true)
    @Schema(description="Unique identification of a Sale transaction")
    protected TransactionIdentification saleTransactionID;
    @XmlElement(name="SaleTerminalData")
    @Schema(description="Information related to the software and hardware feature of the Sale Terminal. --Rule: If content is not empty")
    protected SaleTerminalData saleTerminalData;
    @XmlElement(name="SponsoredMerchant")
    @Schema(description="Merchant using the payment services of a payment facilitator, acting as a card acceptor. --Rule: If the merchant is a payment facilitator providing services to sponsored merchants.")
    protected List<SponsoredMerchant> sponsoredMerchant;
    @XmlElement(name="SaleToPOIData")
    @Schema(description="Sale information intended for the POI. --Rule: Stored with the transaction")
    protected String saleToPOIData;
    @XmlElement(name="SaleToAcquirerData")
    @Schema(description="Sale information intended for the Acquirer. --Rule: Send to the Acquirer if present")
    @JsonAdapter(value=SaleToAcquirerDataSerializer.class)
    protected SaleToAcquirerData saleToAcquirerData = new SaleToAcquirerData();
    @XmlElement(name="SaleToIssuerData")
    @Schema(description="Sale information intended for the Issuer. --Rule: Send to the Acquirer if present")
    protected SaleToIssuerData saleToIssuerData;
    @XmlElement(name="OperatorID")
    @Schema(description="Identification of the Cashier or Operator. --Rule: if different from the Login and  see Login .SaleData")
    protected String operatorID;
    @XmlElement(name="OperatorLanguage")
    @Schema(description="Language of the Cashier or Operator. --Rule: if different from the Login")
    protected String operatorLanguage;
    @XmlElement(name="ShiftNumber")
    @Schema(description="Shift number. --Rule: if different from the Login and  see Login .SaleData")
    protected String shiftNumber;
    @XmlElement(name="SaleReferenceID")
    @Schema(description="Identification of a Sale global transaction for a sequence of related POI transactions --Rule: If payment reservation")
    protected String saleReferenceID;
    @XmlElement(name="TokenRequestedType")
    @Schema(description="Type of token replacing the PAN of a payment card to identify the payment mean of the customer. --Rule: In a Payment or CardAcquisition request, if a token is requested.")
    protected TokenRequestedType tokenRequestedType;
    @XmlElement(name="CustomerOrderID")
    @Schema(description="Identification of a customer order. --Rule: If the payment is related to an open customer order.")
    protected String customerOrderID;
    @XmlElement(name="CustomerOrderReq")
    @Schema(description="List of customer orders must be sent in response message. --Rule: If customer orders must be listed in the response message.")
    protected List<CustomerOrderReqType> customerOrderReq;

    public TransactionIdentification getSaleTransactionID() {
        return this.saleTransactionID;
    }

    public void setSaleTransactionID(TransactionIdentification value) {
        this.saleTransactionID = value;
    }

    public SaleTerminalData getSaleTerminalData() {
        return this.saleTerminalData;
    }

    public void setSaleTerminalData(SaleTerminalData value) {
        this.saleTerminalData = value;
    }

    public List<SponsoredMerchant> getSponsoredMerchant() {
        if (this.sponsoredMerchant == null) {
            this.sponsoredMerchant = new ArrayList<SponsoredMerchant>();
        }
        return this.sponsoredMerchant;
    }

    public String getSaleToPOIData() {
        return this.saleToPOIData;
    }

    public void setSaleToPOIData(String value) {
        this.saleToPOIData = value;
    }

    public SaleToAcquirerData getSaleToAcquirerData() {
        return this.saleToAcquirerData;
    }

    public void setSaleToAcquirerData(SaleToAcquirerData value) {
        this.saleToAcquirerData = value;
    }

    public SaleToIssuerData getSaleToIssuerData() {
        return this.saleToIssuerData;
    }

    public void setSaleToIssuerData(SaleToIssuerData value) {
        this.saleToIssuerData = value;
    }

    public String getOperatorID() {
        return this.operatorID;
    }

    public void setOperatorID(String value) {
        this.operatorID = value;
    }

    public String getOperatorLanguage() {
        return this.operatorLanguage;
    }

    public void setOperatorLanguage(String value) {
        this.operatorLanguage = value;
    }

    public String getShiftNumber() {
        return this.shiftNumber;
    }

    public void setShiftNumber(String value) {
        this.shiftNumber = value;
    }

    public String getSaleReferenceID() {
        return this.saleReferenceID;
    }

    public void setSaleReferenceID(String value) {
        this.saleReferenceID = value;
    }

    public TokenRequestedType getTokenRequestedType() {
        return this.tokenRequestedType;
    }

    public void setTokenRequestedType(TokenRequestedType value) {
        this.tokenRequestedType = value;
    }

    public String getCustomerOrderID() {
        return this.customerOrderID;
    }

    public void setCustomerOrderID(String value) {
        this.customerOrderID = value;
    }

    public List<CustomerOrderReqType> getCustomerOrderReq() {
        if (this.customerOrderReq == null) {
            this.customerOrderReq = new ArrayList<CustomerOrderReqType>();
        }
        return this.customerOrderReq;
    }
}

