/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.ErrorFieldType;
import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"content", "contentType", "invalidFields", "pspReference", "resultCode"})
public class GetTaxFormResponse {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private byte[] content;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;

    public GetTaxFormResponse content(byte[] content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="The content of the tax form in the Base64 binary format.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(byte[] content) {
        this.content = content;
    }

    public GetTaxFormResponse contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="The content type of the tax form.")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public GetTaxFormResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public GetTaxFormResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Contains field validation errors that would prevent requests from being processed.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public GetTaxFormResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public GetTaxFormResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTaxFormResponse getTaxFormResponse = (GetTaxFormResponse)o;
        return Arrays.equals(this.content, getTaxFormResponse.content) && Objects.equals(this.contentType, getTaxFormResponse.contentType) && Objects.equals(this.invalidFields, getTaxFormResponse.invalidFields) && Objects.equals(this.pspReference, getTaxFormResponse.pspReference) && Objects.equals(this.resultCode, getTaxFormResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.content), this.contentType, this.invalidFields, this.pspReference, this.resultCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTaxFormResponse {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTaxFormResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetTaxFormResponse)JSON.getMapper().readValue(jsonString, GetTaxFormResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

