/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "stores"})
public class CloseStoresRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_STORES = "stores";
    private List<String> stores = new ArrayList<String>();

    public CloseStoresRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public CloseStoresRequest stores(List<String> stores) {
        this.stores = stores;
        return this;
    }

    public CloseStoresRequest addStoresItem(String storesItem) {
        this.stores.add(storesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of stores to be closed.")
    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getStores() {
        return this.stores;
    }

    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStores(List<String> stores) {
        this.stores = stores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloseStoresRequest closeStoresRequest = (CloseStoresRequest)o;
        return Objects.equals(this.accountHolderCode, closeStoresRequest.accountHolderCode) && Objects.equals(this.stores, closeStoresRequest.stores);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.stores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloseStoresRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CloseStoresRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CloseStoresRequest)JSON.getMapper().readValue(jsonString, CloseStoresRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

