/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Amount;
import com.adyen.model.legalentitymanagement.Financier;
import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"adyenProcessedFunds", "amount", "assetMonthsHeld", "cryptocurrencyExchange", "dateOfFundsReceived", "dateOfSourceEvent", "description", "financiers", "originatorLegalEntityId", "purpose", "relationship", "type", "website"})
public class SourceOfFunds {
    public static final String JSON_PROPERTY_ADYEN_PROCESSED_FUNDS = "adyenProcessedFunds";
    private Boolean adyenProcessedFunds;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_ASSET_MONTHS_HELD = "assetMonthsHeld";
    private Integer assetMonthsHeld;
    public static final String JSON_PROPERTY_CRYPTOCURRENCY_EXCHANGE = "cryptocurrencyExchange";
    private String cryptocurrencyExchange;
    public static final String JSON_PROPERTY_DATE_OF_FUNDS_RECEIVED = "dateOfFundsReceived";
    private LocalDate dateOfFundsReceived;
    public static final String JSON_PROPERTY_DATE_OF_SOURCE_EVENT = "dateOfSourceEvent";
    private LocalDate dateOfSourceEvent;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FINANCIERS = "financiers";
    private List<Financier> financiers;
    public static final String JSON_PROPERTY_ORIGINATOR_LEGAL_ENTITY_ID = "originatorLegalEntityId";
    private String originatorLegalEntityId;
    public static final String JSON_PROPERTY_PURPOSE = "purpose";
    private String purpose;
    public static final String JSON_PROPERTY_RELATIONSHIP = "relationship";
    private String relationship;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private String website;

    public SourceOfFunds adyenProcessedFunds(Boolean adyenProcessedFunds) {
        this.adyenProcessedFunds = adyenProcessedFunds;
        return this;
    }

    @JsonProperty(value="adyenProcessedFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAdyenProcessedFunds() {
        return this.adyenProcessedFunds;
    }

    @JsonProperty(value="adyenProcessedFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenProcessedFunds(Boolean adyenProcessedFunds) {
        this.adyenProcessedFunds = adyenProcessedFunds;
    }

    public SourceOfFunds amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public SourceOfFunds assetMonthsHeld(Integer assetMonthsHeld) {
        this.assetMonthsHeld = assetMonthsHeld;
        return this;
    }

    @JsonProperty(value="assetMonthsHeld")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAssetMonthsHeld() {
        return this.assetMonthsHeld;
    }

    @JsonProperty(value="assetMonthsHeld")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetMonthsHeld(Integer assetMonthsHeld) {
        this.assetMonthsHeld = assetMonthsHeld;
    }

    public SourceOfFunds cryptocurrencyExchange(String cryptocurrencyExchange) {
        this.cryptocurrencyExchange = cryptocurrencyExchange;
        return this;
    }

    @JsonProperty(value="cryptocurrencyExchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCryptocurrencyExchange() {
        return this.cryptocurrencyExchange;
    }

    @JsonProperty(value="cryptocurrencyExchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCryptocurrencyExchange(String cryptocurrencyExchange) {
        this.cryptocurrencyExchange = cryptocurrencyExchange;
    }

    public SourceOfFunds dateOfFundsReceived(LocalDate dateOfFundsReceived) {
        this.dateOfFundsReceived = dateOfFundsReceived;
        return this;
    }

    @JsonProperty(value="dateOfFundsReceived")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfFundsReceived() {
        return this.dateOfFundsReceived;
    }

    @JsonProperty(value="dateOfFundsReceived")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfFundsReceived(LocalDate dateOfFundsReceived) {
        this.dateOfFundsReceived = dateOfFundsReceived;
    }

    public SourceOfFunds dateOfSourceEvent(LocalDate dateOfSourceEvent) {
        this.dateOfSourceEvent = dateOfSourceEvent;
        return this;
    }

    @JsonProperty(value="dateOfSourceEvent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfSourceEvent() {
        return this.dateOfSourceEvent;
    }

    @JsonProperty(value="dateOfSourceEvent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfSourceEvent(LocalDate dateOfSourceEvent) {
        this.dateOfSourceEvent = dateOfSourceEvent;
    }

    public SourceOfFunds description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SourceOfFunds financiers(List<Financier> financiers) {
        this.financiers = financiers;
        return this;
    }

    public SourceOfFunds addFinanciersItem(Financier financiersItem) {
        if (this.financiers == null) {
            this.financiers = new ArrayList<Financier>();
        }
        this.financiers.add(financiersItem);
        return this;
    }

    @JsonProperty(value="financiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Financier> getFinanciers() {
        return this.financiers;
    }

    @JsonProperty(value="financiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinanciers(List<Financier> financiers) {
        this.financiers = financiers;
    }

    public SourceOfFunds originatorLegalEntityId(String originatorLegalEntityId) {
        this.originatorLegalEntityId = originatorLegalEntityId;
        return this;
    }

    @JsonProperty(value="originatorLegalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginatorLegalEntityId() {
        return this.originatorLegalEntityId;
    }

    @JsonProperty(value="originatorLegalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginatorLegalEntityId(String originatorLegalEntityId) {
        this.originatorLegalEntityId = originatorLegalEntityId;
    }

    public SourceOfFunds purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPurpose() {
        return this.purpose;
    }

    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public SourceOfFunds relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @JsonProperty(value="relationship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelationship() {
        return this.relationship;
    }

    @JsonProperty(value="relationship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public SourceOfFunds type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SourceOfFunds website(String website) {
        this.website = website;
        return this;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(String website) {
        this.website = website;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceOfFunds sourceOfFunds = (SourceOfFunds)o;
        return Objects.equals(this.adyenProcessedFunds, sourceOfFunds.adyenProcessedFunds) && Objects.equals(this.amount, sourceOfFunds.amount) && Objects.equals(this.assetMonthsHeld, sourceOfFunds.assetMonthsHeld) && Objects.equals(this.cryptocurrencyExchange, sourceOfFunds.cryptocurrencyExchange) && Objects.equals(this.dateOfFundsReceived, sourceOfFunds.dateOfFundsReceived) && Objects.equals(this.dateOfSourceEvent, sourceOfFunds.dateOfSourceEvent) && Objects.equals(this.description, sourceOfFunds.description) && Objects.equals(this.financiers, sourceOfFunds.financiers) && Objects.equals(this.originatorLegalEntityId, sourceOfFunds.originatorLegalEntityId) && Objects.equals(this.purpose, sourceOfFunds.purpose) && Objects.equals(this.relationship, sourceOfFunds.relationship) && Objects.equals((Object)this.type, (Object)sourceOfFunds.type) && Objects.equals(this.website, sourceOfFunds.website);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.adyenProcessedFunds, this.amount, this.assetMonthsHeld, this.cryptocurrencyExchange, this.dateOfFundsReceived, this.dateOfSourceEvent, this.description, this.financiers, this.originatorLegalEntityId, this.purpose, this.relationship, this.type, this.website});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceOfFunds {\n");
        sb.append("    adyenProcessedFunds: ").append(this.toIndentedString(this.adyenProcessedFunds)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    assetMonthsHeld: ").append(this.toIndentedString(this.assetMonthsHeld)).append("\n");
        sb.append("    cryptocurrencyExchange: ").append(this.toIndentedString(this.cryptocurrencyExchange)).append("\n");
        sb.append("    dateOfFundsReceived: ").append(this.toIndentedString(this.dateOfFundsReceived)).append("\n");
        sb.append("    dateOfSourceEvent: ").append(this.toIndentedString(this.dateOfSourceEvent)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    financiers: ").append(this.toIndentedString(this.financiers)).append("\n");
        sb.append("    originatorLegalEntityId: ").append(this.toIndentedString(this.originatorLegalEntityId)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString(this.relationship)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SourceOfFunds fromJson(String jsonString) throws JsonProcessingException {
        return (SourceOfFunds)JSON.getMapper().readValue(jsonString, SourceOfFunds.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BUSINESS(String.valueOf("business")),
        EMPLOYMENT(String.valueOf("employment")),
        DONATIONS(String.valueOf("donations")),
        INHERITANCE(String.valueOf("inheritance")),
        FINANCIALAID(String.valueOf("financialAid")),
        RENTALINCOME(String.valueOf("rentalIncome")),
        DIVIDENDINCOME(String.valueOf("dividendIncome")),
        ROYALTYINCOME(String.valueOf("royaltyIncome")),
        THIRDPARTYFUNDING(String.valueOf("thirdPartyFunding")),
        PENSIONINCOME(String.valueOf("pensionIncome")),
        INSURANCESETTLEMENT(String.valueOf("insuranceSettlement")),
        CRYPTOCURRENCYINCOME(String.valueOf("cryptocurrencyIncome")),
        ASSETSALE(String.valueOf("assetSale")),
        LOANS(String.valueOf("loans")),
        GAMBLINGWINNINGS(String.valueOf("gamblingWinnings"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

