/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"addressMatch", "deliveryAddressIndicator", "deliveryEmail", "deliveryEmailAddress", "deliveryTimeframe", "giftCardAmount", "giftCardCount", "giftCardCurr", "preOrderDate", "preOrderPurchase", "preOrderPurchaseInd", "reorderItems", "reorderItemsInd", "shipIndicator"})
public class MerchantRiskIndicator {
    public static final String JSON_PROPERTY_ADDRESS_MATCH = "addressMatch";
    private Boolean addressMatch;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS_INDICATOR = "deliveryAddressIndicator";
    private DeliveryAddressIndicatorEnum deliveryAddressIndicator;
    public static final String JSON_PROPERTY_DELIVERY_EMAIL = "deliveryEmail";
    @Deprecated
    private String deliveryEmail;
    public static final String JSON_PROPERTY_DELIVERY_EMAIL_ADDRESS = "deliveryEmailAddress";
    private String deliveryEmailAddress;
    public static final String JSON_PROPERTY_DELIVERY_TIMEFRAME = "deliveryTimeframe";
    private DeliveryTimeframeEnum deliveryTimeframe;
    public static final String JSON_PROPERTY_GIFT_CARD_AMOUNT = "giftCardAmount";
    private Amount giftCardAmount;
    public static final String JSON_PROPERTY_GIFT_CARD_COUNT = "giftCardCount";
    private Integer giftCardCount;
    public static final String JSON_PROPERTY_GIFT_CARD_CURR = "giftCardCurr";
    private String giftCardCurr;
    public static final String JSON_PROPERTY_PRE_ORDER_DATE = "preOrderDate";
    private OffsetDateTime preOrderDate;
    public static final String JSON_PROPERTY_PRE_ORDER_PURCHASE = "preOrderPurchase";
    private Boolean preOrderPurchase;
    public static final String JSON_PROPERTY_PRE_ORDER_PURCHASE_IND = "preOrderPurchaseInd";
    private String preOrderPurchaseInd;
    public static final String JSON_PROPERTY_REORDER_ITEMS = "reorderItems";
    private Boolean reorderItems;
    public static final String JSON_PROPERTY_REORDER_ITEMS_IND = "reorderItemsInd";
    private String reorderItemsInd;
    public static final String JSON_PROPERTY_SHIP_INDICATOR = "shipIndicator";
    private String shipIndicator;

    public MerchantRiskIndicator addressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
        return this;
    }

    @JsonProperty(value="addressMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAddressMatch() {
        return this.addressMatch;
    }

    @JsonProperty(value="addressMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
    }

    public MerchantRiskIndicator deliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
        return this;
    }

    @JsonProperty(value="deliveryAddressIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryAddressIndicatorEnum getDeliveryAddressIndicator() {
        return this.deliveryAddressIndicator;
    }

    @JsonProperty(value="deliveryAddressIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
    }

    @Deprecated
    public MerchantRiskIndicator deliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
        return this;
    }

    @Deprecated
    @JsonProperty(value="deliveryEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryEmail() {
        return this.deliveryEmail;
    }

    @Deprecated
    @JsonProperty(value="deliveryEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
    }

    public MerchantRiskIndicator deliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
        return this;
    }

    @JsonProperty(value="deliveryEmailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryEmailAddress() {
        return this.deliveryEmailAddress;
    }

    @JsonProperty(value="deliveryEmailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
    }

    public MerchantRiskIndicator deliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
        return this;
    }

    @JsonProperty(value="deliveryTimeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryTimeframeEnum getDeliveryTimeframe() {
        return this.deliveryTimeframe;
    }

    @JsonProperty(value="deliveryTimeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
    }

    public MerchantRiskIndicator giftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
        return this;
    }

    @JsonProperty(value="giftCardAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getGiftCardAmount() {
        return this.giftCardAmount;
    }

    @JsonProperty(value="giftCardAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public MerchantRiskIndicator giftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
        return this;
    }

    @JsonProperty(value="giftCardCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGiftCardCount() {
        return this.giftCardCount;
    }

    @JsonProperty(value="giftCardCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
    }

    public MerchantRiskIndicator giftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
        return this;
    }

    @JsonProperty(value="giftCardCurr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGiftCardCurr() {
        return this.giftCardCurr;
    }

    @JsonProperty(value="giftCardCurr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
    }

    public MerchantRiskIndicator preOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
        return this;
    }

    @JsonProperty(value="preOrderDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getPreOrderDate() {
        return this.preOrderDate;
    }

    @JsonProperty(value="preOrderDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
    }

    public MerchantRiskIndicator preOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
        return this;
    }

    @JsonProperty(value="preOrderPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreOrderPurchase() {
        return this.preOrderPurchase;
    }

    @JsonProperty(value="preOrderPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
    }

    public MerchantRiskIndicator preOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
        return this;
    }

    @JsonProperty(value="preOrderPurchaseInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreOrderPurchaseInd() {
        return this.preOrderPurchaseInd;
    }

    @JsonProperty(value="preOrderPurchaseInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
    }

    public MerchantRiskIndicator reorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
        return this;
    }

    @JsonProperty(value="reorderItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReorderItems() {
        return this.reorderItems;
    }

    @JsonProperty(value="reorderItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
    }

    public MerchantRiskIndicator reorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
        return this;
    }

    @JsonProperty(value="reorderItemsInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReorderItemsInd() {
        return this.reorderItemsInd;
    }

    @JsonProperty(value="reorderItemsInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
    }

    public MerchantRiskIndicator shipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
        return this;
    }

    @JsonProperty(value="shipIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShipIndicator() {
        return this.shipIndicator;
    }

    @JsonProperty(value="shipIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantRiskIndicator merchantRiskIndicator = (MerchantRiskIndicator)o;
        return Objects.equals(this.addressMatch, merchantRiskIndicator.addressMatch) && Objects.equals((Object)this.deliveryAddressIndicator, (Object)merchantRiskIndicator.deliveryAddressIndicator) && Objects.equals(this.deliveryEmail, merchantRiskIndicator.deliveryEmail) && Objects.equals(this.deliveryEmailAddress, merchantRiskIndicator.deliveryEmailAddress) && Objects.equals((Object)this.deliveryTimeframe, (Object)merchantRiskIndicator.deliveryTimeframe) && Objects.equals(this.giftCardAmount, merchantRiskIndicator.giftCardAmount) && Objects.equals(this.giftCardCount, merchantRiskIndicator.giftCardCount) && Objects.equals(this.giftCardCurr, merchantRiskIndicator.giftCardCurr) && Objects.equals(this.preOrderDate, merchantRiskIndicator.preOrderDate) && Objects.equals(this.preOrderPurchase, merchantRiskIndicator.preOrderPurchase) && Objects.equals(this.preOrderPurchaseInd, merchantRiskIndicator.preOrderPurchaseInd) && Objects.equals(this.reorderItems, merchantRiskIndicator.reorderItems) && Objects.equals(this.reorderItemsInd, merchantRiskIndicator.reorderItemsInd) && Objects.equals(this.shipIndicator, merchantRiskIndicator.shipIndicator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressMatch, this.deliveryAddressIndicator, this.deliveryEmail, this.deliveryEmailAddress, this.deliveryTimeframe, this.giftCardAmount, this.giftCardCount, this.giftCardCurr, this.preOrderDate, this.preOrderPurchase, this.preOrderPurchaseInd, this.reorderItems, this.reorderItemsInd, this.shipIndicator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantRiskIndicator {\n");
        sb.append("    addressMatch: ").append(this.toIndentedString(this.addressMatch)).append("\n");
        sb.append("    deliveryAddressIndicator: ").append(this.toIndentedString((Object)this.deliveryAddressIndicator)).append("\n");
        sb.append("    deliveryEmail: ").append(this.toIndentedString(this.deliveryEmail)).append("\n");
        sb.append("    deliveryEmailAddress: ").append(this.toIndentedString(this.deliveryEmailAddress)).append("\n");
        sb.append("    deliveryTimeframe: ").append(this.toIndentedString((Object)this.deliveryTimeframe)).append("\n");
        sb.append("    giftCardAmount: ").append(this.toIndentedString(this.giftCardAmount)).append("\n");
        sb.append("    giftCardCount: ").append(this.toIndentedString(this.giftCardCount)).append("\n");
        sb.append("    giftCardCurr: ").append(this.toIndentedString(this.giftCardCurr)).append("\n");
        sb.append("    preOrderDate: ").append(this.toIndentedString(this.preOrderDate)).append("\n");
        sb.append("    preOrderPurchase: ").append(this.toIndentedString(this.preOrderPurchase)).append("\n");
        sb.append("    preOrderPurchaseInd: ").append(this.toIndentedString(this.preOrderPurchaseInd)).append("\n");
        sb.append("    reorderItems: ").append(this.toIndentedString(this.reorderItems)).append("\n");
        sb.append("    reorderItemsInd: ").append(this.toIndentedString(this.reorderItemsInd)).append("\n");
        sb.append("    shipIndicator: ").append(this.toIndentedString(this.shipIndicator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantRiskIndicator fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantRiskIndicator)JSON.getMapper().readValue(jsonString, MerchantRiskIndicator.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum DeliveryTimeframeEnum {
        ELECTRONICDELIVERY(String.valueOf("electronicDelivery")),
        SAMEDAYSHIPPING(String.valueOf("sameDayShipping")),
        OVERNIGHTSHIPPING(String.valueOf("overnightShipping")),
        TWOORMOREDAYSSHIPPING(String.valueOf("twoOrMoreDaysShipping"));

        private static final Logger LOG;
        private String value;

        private DeliveryTimeframeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryTimeframeEnum fromValue(String value) {
            for (DeliveryTimeframeEnum b : DeliveryTimeframeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DeliveryTimeframeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DeliveryTimeframeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DeliveryTimeframeEnum.class.getName());
        }
    }

    public static enum DeliveryAddressIndicatorEnum {
        SHIPTOBILLINGADDRESS(String.valueOf("shipToBillingAddress")),
        SHIPTOVERIFIEDADDRESS(String.valueOf("shipToVerifiedAddress")),
        SHIPTONEWADDRESS(String.valueOf("shipToNewAddress")),
        SHIPTOSTORE(String.valueOf("shipToStore")),
        DIGITALGOODS(String.valueOf("digitalGoods")),
        GOODSNOTSHIPPED(String.valueOf("goodsNotShipped")),
        OTHER(String.valueOf("other"));

        private static final Logger LOG;
        private String value;

        private DeliveryAddressIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryAddressIndicatorEnum fromValue(String value) {
            for (DeliveryAddressIndicatorEnum b : DeliveryAddressIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DeliveryAddressIndicatorEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DeliveryAddressIndicatorEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DeliveryAddressIndicatorEnum.class.getName());
        }
    }
}

