/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.ForceEntryModeType;
import com.adyen.model.nexo.LoyaltyHandlingType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TransactionConditions", propOrder={"allowedPaymentBrand", "acquirerID", "allowedLoyaltyBrand", "forceEntryMode"})
public class TransactionConditions {
    @XmlElement(name="AllowedPaymentBrand")
    @Schema(description="Card payment brands allowed by the Sale System for the payment transaction. --Rule: Restrict brand if data sent")
    protected List<String> allowedPaymentBrand;
    @XmlElement(name="AcquirerID")
    @Schema(description="Identification of the Acquirer --Rule: Restrict to these Acquirer if present")
    protected List<String> acquirerID;
    @XmlElement(name="AllowedLoyaltyBrand")
    @Schema(description="Loyalty brands or programs allowed by the Sale System for the loyalty transaction. --Rule: Restrict brand if data sent")
    protected List<String> allowedLoyaltyBrand;
    @XmlElement(name="ForceEntryMode")
    @Schema(description="Payment instrument entry mode requested by the Sale System. --Rule: Restrict entry mode if sent")
    protected List<ForceEntryModeType> forceEntryMode;
    @XmlElement(name="DebitPreferredFlag")
    @Schema(description="The preferred type of payment is a debit transaction rather a credit transaction. --Rule: The preferred type of payment is a debit transaction rather a credit transaction.")
    protected Boolean debitPreferredFlag;
    @XmlElement(name="LoyaltyHandling")
    @Schema(description="Type of Loyalty processing requested by the Sale System.")
    protected LoyaltyHandlingType loyaltyHandling;
    @XmlElement(name="CustomerLanguage")
    @Schema(description="Language of the Customer --Rule: If the language is selected by the Sale System before the request to the POI.")
    protected String customerLanguage;
    @XmlElement(name="ForceOnlineFlag")
    @Schema(description="Indicates if the Cashier requires POI forces online access to the Acquirer. --Rule:  Go online if data sent")
    protected Boolean forceOnlineFlag;
    @XmlElement(name="MerchantCategoryCode")
    @Schema(description="The code which identifies the category of the transaction (MCC). --Rule: The payment implies a specific MCC.", minLength=3, maxLength=4)
    protected String merchantCategoryCode;

    public List<String> getAllowedPaymentBrand() {
        if (this.allowedPaymentBrand == null) {
            this.allowedPaymentBrand = new ArrayList<String>();
        }
        return this.allowedPaymentBrand;
    }

    public List<String> getAcquirerID() {
        if (this.acquirerID == null) {
            this.acquirerID = new ArrayList<String>();
        }
        return this.acquirerID;
    }

    public List<String> getAllowedLoyaltyBrand() {
        if (this.allowedLoyaltyBrand == null) {
            this.allowedLoyaltyBrand = new ArrayList<String>();
        }
        return this.allowedLoyaltyBrand;
    }

    public List<ForceEntryModeType> getForceEntryMode() {
        if (this.forceEntryMode == null) {
            this.forceEntryMode = new ArrayList<ForceEntryModeType>();
        }
        return this.forceEntryMode;
    }

    public boolean isDebitPreferredFlag() {
        if (this.debitPreferredFlag == null) {
            return false;
        }
        return this.debitPreferredFlag;
    }

    public void setDebitPreferredFlag(Boolean value) {
        this.debitPreferredFlag = value;
    }

    public LoyaltyHandlingType getLoyaltyHandling() {
        if (this.loyaltyHandling == null) {
            return LoyaltyHandlingType.FORBIDDEN;
        }
        return this.loyaltyHandling;
    }

    public void setLoyaltyHandling(LoyaltyHandlingType value) {
        this.loyaltyHandling = value;
    }

    public String getCustomerLanguage() {
        return this.customerLanguage;
    }

    public void setCustomerLanguage(String value) {
        this.customerLanguage = value;
    }

    public boolean isForceOnlineFlag() {
        if (this.forceOnlineFlag == null) {
            return false;
        }
        return this.forceOnlineFlag;
    }

    public void setForceOnlineFlag(Boolean value) {
        this.forceOnlineFlag = value;
    }

    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String value) {
        this.merchantCategoryCode = value;
    }
}

