/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.Amount;
import com.adyen.model.marketpayfund.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountHolderCode", "amount", "bankAccountUUID", "description", "merchantReference", "payoutMethodCode", "payoutSpeed"})
public class PayoutAccountHolderRequest {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed = PayoutSpeedEnum.STANDARD;

    public PayoutAccountHolderRequest accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account from which the payout is to be made.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public PayoutAccountHolderRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the Account Holder who owns the account from which the payout is to be made. The Account Holder is the party to which the payout will be made.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public PayoutAccountHolderRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PayoutAccountHolderRequest bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the Bank Account held by the Account Holder to which the payout is to be made. If left blank, a bank account is automatically selected.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public PayoutAccountHolderRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the payout. Maximum 200 characters. Allowed: **abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/?:().,'+ \";**")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PayoutAccountHolderRequest merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="A value that can be supplied at the discretion of the executing user in order to link multiple transactions to one another.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public PayoutAccountHolderRequest payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the payout method held by the Account Holder to which the payout is to be made. If left blank, a payout instrument is automatically selected.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public PayoutAccountHolderRequest payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutAccountHolderRequest payoutAccountHolderRequest = (PayoutAccountHolderRequest)o;
        return Objects.equals(this.accountCode, payoutAccountHolderRequest.accountCode) && Objects.equals(this.accountHolderCode, payoutAccountHolderRequest.accountHolderCode) && Objects.equals(this.amount, payoutAccountHolderRequest.amount) && Objects.equals(this.bankAccountUUID, payoutAccountHolderRequest.bankAccountUUID) && Objects.equals(this.description, payoutAccountHolderRequest.description) && Objects.equals(this.merchantReference, payoutAccountHolderRequest.merchantReference) && Objects.equals(this.payoutMethodCode, payoutAccountHolderRequest.payoutMethodCode) && Objects.equals((Object)this.payoutSpeed, (Object)payoutAccountHolderRequest.payoutSpeed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountCode, this.accountHolderCode, this.amount, this.bankAccountUUID, this.description, this.merchantReference, this.payoutMethodCode, this.payoutSpeed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutAccountHolderRequest {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutAccountHolderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutAccountHolderRequest)JSON.getMapper().readValue(jsonString, PayoutAccountHolderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

