/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.Amount;
import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"allowPayout", "disableReason", "disabled", "notAllowedReason", "payoutLimit", "tierNumber"})
public class AccountPayoutState {
    public static final String JSON_PROPERTY_ALLOW_PAYOUT = "allowPayout";
    private Boolean allowPayout;
    public static final String JSON_PROPERTY_DISABLE_REASON = "disableReason";
    private String disableReason;
    public static final String JSON_PROPERTY_DISABLED = "disabled";
    private Boolean disabled;
    public static final String JSON_PROPERTY_NOT_ALLOWED_REASON = "notAllowedReason";
    private String notAllowedReason;
    public static final String JSON_PROPERTY_PAYOUT_LIMIT = "payoutLimit";
    private Amount payoutLimit;
    public static final String JSON_PROPERTY_TIER_NUMBER = "tierNumber";
    private Integer tierNumber;

    public AccountPayoutState allowPayout(Boolean allowPayout) {
        this.allowPayout = allowPayout;
        return this;
    }

    @ApiModelProperty(value="Indicates whether payouts are allowed. This field is the overarching payout status, and is the aggregate of multiple conditions (e.g., KYC status, disabled flag, etc). If this field is false, no payouts will be permitted for any of the account holder's accounts. If this field is true, payouts will be permitted for any of the account holder's accounts.")
    @JsonProperty(value="allowPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowPayout() {
        return this.allowPayout;
    }

    @JsonProperty(value="allowPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowPayout(Boolean allowPayout) {
        this.allowPayout = allowPayout;
    }

    public AccountPayoutState disableReason(String disableReason) {
        this.disableReason = disableReason;
        return this;
    }

    @ApiModelProperty(value="The reason why payouts (to all of the account holder's accounts) have been disabled (by the platform). If the `disabled` field is true, this field can be used to explain why.")
    @JsonProperty(value="disableReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisableReason() {
        return this.disableReason;
    }

    @JsonProperty(value="disableReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisableReason(String disableReason) {
        this.disableReason = disableReason;
    }

    public AccountPayoutState disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether payouts have been disabled (by the platform) for all of the account holder's accounts. A platform may enable and disable this field at their discretion. If this field is true, `allowPayout` will be false and no payouts will be permitted for any of the account holder's accounts. If this field is false, `allowPayout` may or may not be enabled, depending on other factors.")
    @JsonProperty(value="disabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public AccountPayoutState notAllowedReason(String notAllowedReason) {
        this.notAllowedReason = notAllowedReason;
        return this;
    }

    @ApiModelProperty(value="The reason why payouts (to all of the account holder's accounts) have been disabled (by Adyen). If payouts have been disabled by Adyen, this field will explain why. If this field is blank, payouts have not been disabled by Adyen.")
    @JsonProperty(value="notAllowedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotAllowedReason() {
        return this.notAllowedReason;
    }

    @JsonProperty(value="notAllowedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotAllowedReason(String notAllowedReason) {
        this.notAllowedReason = notAllowedReason;
    }

    public AccountPayoutState payoutLimit(Amount payoutLimit) {
        this.payoutLimit = payoutLimit;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="payoutLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getPayoutLimit() {
        return this.payoutLimit;
    }

    @JsonProperty(value="payoutLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutLimit(Amount payoutLimit) {
        this.payoutLimit = payoutLimit;
    }

    public AccountPayoutState tierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
        return this;
    }

    @ApiModelProperty(value="The payout tier that the account holder occupies.")
    @JsonProperty(value="tierNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTierNumber() {
        return this.tierNumber;
    }

    @JsonProperty(value="tierNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountPayoutState accountPayoutState = (AccountPayoutState)o;
        return Objects.equals(this.allowPayout, accountPayoutState.allowPayout) && Objects.equals(this.disableReason, accountPayoutState.disableReason) && Objects.equals(this.disabled, accountPayoutState.disabled) && Objects.equals(this.notAllowedReason, accountPayoutState.notAllowedReason) && Objects.equals(this.payoutLimit, accountPayoutState.payoutLimit) && Objects.equals(this.tierNumber, accountPayoutState.tierNumber);
    }

    public int hashCode() {
        return Objects.hash(this.allowPayout, this.disableReason, this.disabled, this.notAllowedReason, this.payoutLimit, this.tierNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountPayoutState {\n");
        sb.append("    allowPayout: ").append(this.toIndentedString(this.allowPayout)).append("\n");
        sb.append("    disableReason: ").append(this.toIndentedString(this.disableReason)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    notAllowedReason: ").append(this.toIndentedString(this.notAllowedReason)).append("\n");
        sb.append("    payoutLimit: ").append(this.toIndentedString(this.payoutLimit)).append("\n");
        sb.append("    tierNumber: ").append(this.toIndentedString(this.tierNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountPayoutState fromJson(String jsonString) throws JsonProcessingException {
        return (AccountPayoutState)JSON.getMapper().readValue(jsonString, AccountPayoutState.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

