/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.CustomerOrderReqType;
import com.adyen.model.nexo.SaleSoftware;
import com.adyen.model.nexo.SaleTerminalData;
import com.adyen.model.nexo.TokenRequestedType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LoginRequest", propOrder={"dateTime", "saleSoftware", "saleTerminalData"})
public class LoginRequest {
    @XmlElement(name="DateTime", required=true)
    @Schema(description="Date and Time")
    @XmlSchemaType(name="dateTime")
    protected XMLGregorianCalendar dateTime;
    @XmlElement(name="SaleSoftware", required=true)
    @Schema(description="Information related to the software of the Sale System which manages the Sale to POI protocol.")
    protected SaleSoftware saleSoftware;
    @XmlElement(name="SaleTerminalData")
    @Schema(description="Information related to the software and hardware feature of the Sale Terminal. --Rule: Present if the login involve a Sale Terminal")
    protected SaleTerminalData saleTerminalData;
    @XmlElement(name="TrainingModeFlag")
    @Schema(description="Training mode --Rule: The POI does not realise the transaction with the Acquirer")
    protected Boolean trainingModeFlag;
    @XmlElement(name="OperatorLanguage", required=true)
    @Schema(description="Language of the Cashier or Operator. --Rule: Default value for Device type displays")
    protected String operatorLanguage;
    @XmlElement(name="OperatorID")
    @Schema(description="Identification of the Cashier or Operator. --Rule: 4 conditions to send it: a) the Sale System wants the POI log it in the transaction log b) because of reconciliation")
    protected String operatorID;
    @XmlElement(name="ShiftNumber")
    @Schema(description="Shift number. --Rule: Same as OperatorID")
    protected String shiftNumber;
    @XmlElement(name="TokenRequestedType")
    @Schema(description="Type of token replacing the PAN of a payment card to identify the payment mean of the customer. --Rule: If a token is requested during the the session.")
    protected TokenRequestedType tokenRequestedType;
    @XmlElement(name="CustomerOrderReq")
    @Schema(description="List of customer orders must be sent in response message. --Rule: If customer orders must be listed in Card Acquisition and Payment response messages during the session.")
    protected List<CustomerOrderReqType> customerOrderReq;
    @XmlElement(name="POISerialNumber")
    @Schema(description="Serial number of a POI Terminal --Rule: If the login involve a POI Terminal and not the first Login to the POI System")
    protected String poiSerialNumber;

    public XMLGregorianCalendar getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(XMLGregorianCalendar value) {
        this.dateTime = value;
    }

    public SaleSoftware getSaleSoftware() {
        return this.saleSoftware;
    }

    public void setSaleSoftware(SaleSoftware value) {
        this.saleSoftware = value;
    }

    public SaleTerminalData getSaleTerminalData() {
        return this.saleTerminalData;
    }

    public void setSaleTerminalData(SaleTerminalData value) {
        this.saleTerminalData = value;
    }

    public boolean isTrainingModeFlag() {
        if (this.trainingModeFlag == null) {
            return false;
        }
        return this.trainingModeFlag;
    }

    public void setTrainingModeFlag(Boolean value) {
        this.trainingModeFlag = value;
    }

    public String getOperatorLanguage() {
        return this.operatorLanguage;
    }

    public void setOperatorLanguage(String value) {
        this.operatorLanguage = value;
    }

    public String getOperatorID() {
        return this.operatorID;
    }

    public void setOperatorID(String value) {
        this.operatorID = value;
    }

    public String getShiftNumber() {
        return this.shiftNumber;
    }

    public void setShiftNumber(String value) {
        this.shiftNumber = value;
    }

    public TokenRequestedType getTokenRequestedType() {
        return this.tokenRequestedType;
    }

    public void setTokenRequestedType(TokenRequestedType value) {
        this.tokenRequestedType = value;
    }

    public List<CustomerOrderReqType> getCustomerOrderReq() {
        if (this.customerOrderReq == null) {
            this.customerOrderReq = new ArrayList<CustomerOrderReqType>();
        }
        return this.customerOrderReq;
    }

    public String getPOISerialNumber() {
        return this.poiSerialNumber;
    }

    public void setPOISerialNumber(String value) {
        this.poiSerialNumber = value;
    }
}

