/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountType", "eventDate", "remoteAccessUrl", "success"})
public class ReportAvailableNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private String accountType;
    public static final String JSON_PROPERTY_EVENT_DATE = "eventDate";
    private OffsetDateTime eventDate;
    public static final String JSON_PROPERTY_REMOTE_ACCESS_URL = "remoteAccessUrl";
    private String remoteAccessUrl;
    public static final String JSON_PROPERTY_SUCCESS = "success";
    private Boolean success;

    public ReportAvailableNotificationContent accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Account to which the report applies.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public ReportAvailableNotificationContent accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The type of Account to which the report applies.")
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public ReportAvailableNotificationContent eventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(value="The date of the event to which the report applies.")
    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    @JsonProperty(value="eventDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public ReportAvailableNotificationContent remoteAccessUrl(String remoteAccessUrl) {
        this.remoteAccessUrl = remoteAccessUrl;
        return this;
    }

    @ApiModelProperty(value="The URL at which the report can be accessed.")
    @JsonProperty(value="remoteAccessUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemoteAccessUrl() {
        return this.remoteAccessUrl;
    }

    @JsonProperty(value="remoteAccessUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemoteAccessUrl(String remoteAccessUrl) {
        this.remoteAccessUrl = remoteAccessUrl;
    }

    public ReportAvailableNotificationContent success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the event resulted in a success.")
    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportAvailableNotificationContent reportAvailableNotificationContent = (ReportAvailableNotificationContent)o;
        return Objects.equals(this.accountCode, reportAvailableNotificationContent.accountCode) && Objects.equals(this.accountType, reportAvailableNotificationContent.accountType) && Objects.equals(this.eventDate, reportAvailableNotificationContent.eventDate) && Objects.equals(this.remoteAccessUrl, reportAvailableNotificationContent.remoteAccessUrl) && Objects.equals(this.success, reportAvailableNotificationContent.success);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.accountType, this.eventDate, this.remoteAccessUrl, this.success);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportAvailableNotificationContent {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    remoteAccessUrl: ").append(this.toIndentedString(this.remoteAccessUrl)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ReportAvailableNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (ReportAvailableNotificationContent)JSON.getMapper().readValue(jsonString, ReportAvailableNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

