/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.AccountEvent;
import com.adyen.model.marketpaywebhooks.AccountPayoutState;
import com.adyen.model.marketpaywebhooks.AccountProcessingState;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"events", "payoutState", "processingState", "status", "statusReason"})
public class AccountHolderStatus {
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<AccountEvent> events = null;
    public static final String JSON_PROPERTY_PAYOUT_STATE = "payoutState";
    private AccountPayoutState payoutState;
    public static final String JSON_PROPERTY_PROCESSING_STATE = "processingState";
    private AccountProcessingState processingState;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STATUS_REASON = "statusReason";
    private String statusReason;

    public AccountHolderStatus events(List<AccountEvent> events) {
        this.events = events;
        return this;
    }

    public AccountHolderStatus addEventsItem(AccountEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<AccountEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="A list of events scheduled for the account holder.")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvents(List<AccountEvent> events) {
        this.events = events;
    }

    public AccountHolderStatus payoutState(AccountPayoutState payoutState) {
        this.payoutState = payoutState;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="payoutState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountPayoutState getPayoutState() {
        return this.payoutState;
    }

    @JsonProperty(value="payoutState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutState(AccountPayoutState payoutState) {
        this.payoutState = payoutState;
    }

    public AccountHolderStatus processingState(AccountProcessingState processingState) {
        this.processingState = processingState;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="processingState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountProcessingState getProcessingState() {
        return this.processingState;
    }

    @JsonProperty(value="processingState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessingState(AccountProcessingState processingState) {
        this.processingState = processingState;
    }

    public AccountHolderStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the account holder. >Permitted values: `Active`, `Inactive`, `Suspended`, `Closed`.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountHolderStatus statusReason(String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @ApiModelProperty(value="The reason why the status was assigned to the account holder.")
    @JsonProperty(value="statusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusReason() {
        return this.statusReason;
    }

    @JsonProperty(value="statusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderStatus accountHolderStatus = (AccountHolderStatus)o;
        return Objects.equals(this.events, accountHolderStatus.events) && Objects.equals(this.payoutState, accountHolderStatus.payoutState) && Objects.equals(this.processingState, accountHolderStatus.processingState) && Objects.equals((Object)this.status, (Object)accountHolderStatus.status) && Objects.equals(this.statusReason, accountHolderStatus.statusReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.events, this.payoutState, this.processingState, this.status, this.statusReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderStatus {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    payoutState: ").append(this.toIndentedString(this.payoutState)).append("\n");
        sb.append("    processingState: ").append(this.toIndentedString(this.processingState)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderStatus fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderStatus)JSON.getMapper().readValue(jsonString, AccountHolderStatus.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

