/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.AccountHolderDetails;
import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "accountHolderDetails", "description", "legalEntity", "primaryCurrency", "processingTier", "verificationProfile"})
public class UpdateAccountHolderRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS = "accountHolderDetails";
    private AccountHolderDetails accountHolderDetails;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LEGAL_ENTITY = "legalEntity";
    private LegalEntityEnum legalEntity;
    public static final String JSON_PROPERTY_PRIMARY_CURRENCY = "primaryCurrency";
    private String primaryCurrency;
    public static final String JSON_PROPERTY_PROCESSING_TIER = "processingTier";
    private Integer processingTier;
    public static final String JSON_PROPERTY_VERIFICATION_PROFILE = "verificationProfile";
    private String verificationProfile;

    public UpdateAccountHolderRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the Account Holder to be updated.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public UpdateAccountHolderRequest accountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountHolderDetails getAccountHolderDetails() {
        return this.accountHolderDetails;
    }

    @JsonProperty(value="accountHolderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
    }

    public UpdateAccountHolderRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the account holder, maximum 256 characters. You can use alphanumeric characters (A-Z, a-z, 0-9), white spaces, and underscores `_`.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateAccountHolderRequest legalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
        return this;
    }

    @ApiModelProperty(value="The legal entity type of the account holder. This determines the information that should be provided in the request.  Possible values: **Business**, **Individual**, or **NonProfit**.  * If set to **Business** or **NonProfit**, then `accountHolderDetails.businessDetails` must be provided, with at least one entry in the `accountHolderDetails.businessDetails.shareholders` list.  * If set to **Individual**, then `accountHolderDetails.individualDetails` must be provided.")
    @JsonProperty(value="legalEntity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LegalEntityEnum getLegalEntity() {
        return this.legalEntity;
    }

    @JsonProperty(value="legalEntity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
    }

    public UpdateAccountHolderRequest primaryCurrency(String primaryCurrency) {
        this.primaryCurrency = primaryCurrency;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The primary three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes), to which the account holder should be updated.")
    @JsonProperty(value="primaryCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrimaryCurrency() {
        return this.primaryCurrency;
    }

    @Deprecated
    @JsonProperty(value="primaryCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryCurrency(String primaryCurrency) {
        this.primaryCurrency = primaryCurrency;
    }

    public UpdateAccountHolderRequest processingTier(Integer processingTier) {
        this.processingTier = processingTier;
        return this;
    }

    @ApiModelProperty(value="The processing tier to which the Account Holder should be updated. >The processing tier can not be lowered through this request.  >Required if accountHolderDetails are not provided.")
    @JsonProperty(value="processingTier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getProcessingTier() {
        return this.processingTier;
    }

    @JsonProperty(value="processingTier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessingTier(Integer processingTier) {
        this.processingTier = processingTier;
    }

    public UpdateAccountHolderRequest verificationProfile(String verificationProfile) {
        this.verificationProfile = verificationProfile;
        return this;
    }

    @ApiModelProperty(value="The identifier of the profile that applies to this entity.")
    @JsonProperty(value="verificationProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationProfile() {
        return this.verificationProfile;
    }

    @JsonProperty(value="verificationProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationProfile(String verificationProfile) {
        this.verificationProfile = verificationProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountHolderRequest updateAccountHolderRequest = (UpdateAccountHolderRequest)o;
        return Objects.equals(this.accountHolderCode, updateAccountHolderRequest.accountHolderCode) && Objects.equals(this.accountHolderDetails, updateAccountHolderRequest.accountHolderDetails) && Objects.equals(this.description, updateAccountHolderRequest.description) && Objects.equals((Object)this.legalEntity, (Object)updateAccountHolderRequest.legalEntity) && Objects.equals(this.primaryCurrency, updateAccountHolderRequest.primaryCurrency) && Objects.equals(this.processingTier, updateAccountHolderRequest.processingTier) && Objects.equals(this.verificationProfile, updateAccountHolderRequest.verificationProfile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.accountHolderDetails, this.description, this.legalEntity, this.primaryCurrency, this.processingTier, this.verificationProfile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccountHolderRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    accountHolderDetails: ").append(this.toIndentedString(this.accountHolderDetails)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legalEntity: ").append(this.toIndentedString((Object)this.legalEntity)).append("\n");
        sb.append("    primaryCurrency: ").append(this.toIndentedString(this.primaryCurrency)).append("\n");
        sb.append("    processingTier: ").append(this.toIndentedString(this.processingTier)).append("\n");
        sb.append("    verificationProfile: ").append(this.toIndentedString(this.verificationProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateAccountHolderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateAccountHolderRequest)JSON.getMapper().readValue(jsonString, UpdateAccountHolderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum LegalEntityEnum {
        BUSINESS("Business"),
        INDIVIDUAL("Individual"),
        NONPROFIT("NonProfit"),
        PARTNERSHIP("Partnership"),
        PUBLICCOMPANY("PublicCompany");

        private String value;

        private LegalEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LegalEntityEnum fromValue(String value) {
            for (LegalEntityEnum b : LegalEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

