/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.BusinessDetails;
import com.adyen.model.marketpayaccount.IndividualDetails;
import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.ViasAddress;
import com.adyen.model.marketpayaccount.ViasPhoneNumber;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "businessDetails", "email", "fullPhoneNumber", "individualDetails", "legalArrangementEntityCode", "legalArrangementEntityReference", "legalArrangementMembers", "legalEntityType", "phoneNumber", "webAddress"})
public class LegalArrangementEntityDetail {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_BUSINESS_DETAILS = "businessDetails";
    private BusinessDetails businessDetails;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
    private String fullPhoneNumber;
    public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS = "individualDetails";
    private IndividualDetails individualDetails;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE = "legalArrangementEntityCode";
    private String legalArrangementEntityCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_REFERENCE = "legalArrangementEntityReference";
    private String legalArrangementEntityReference;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_MEMBERS = "legalArrangementMembers";
    private List<LegalArrangementMembersEnum> legalArrangementMembers = null;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_TYPE = "legalEntityType";
    private LegalEntityTypeEnum legalEntityType;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private ViasPhoneNumber phoneNumber;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public LegalArrangementEntityDetail address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public LegalArrangementEntityDetail businessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessDetails getBusinessDetails() {
        return this.businessDetails;
    }

    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
    }

    public LegalArrangementEntityDetail email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The e-mail address of the entity.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public LegalArrangementEntityDetail fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the contact provided as a single string.  It will be handled as a landline phone. **Examples:** \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public LegalArrangementEntityDetail individualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndividualDetails getIndividualDetails() {
        return this.individualDetails;
    }

    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
    }

    public LegalArrangementEntityDetail legalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
        return this;
    }

    @ApiModelProperty(value="Adyen-generated unique alphanumeric identifier (UUID) for the entry, returned in the response when you create a legal arrangement entity. Use only when updating an account holder. If you include this field when creating an account holder, the request will fail.")
    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementEntityCode() {
        return this.legalArrangementEntityCode;
    }

    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
    }

    public LegalArrangementEntityDetail legalArrangementEntityReference(String legalArrangementEntityReference) {
        this.legalArrangementEntityReference = legalArrangementEntityReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal arrangement entity.")
    @JsonProperty(value="legalArrangementEntityReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementEntityReference() {
        return this.legalArrangementEntityReference;
    }

    @JsonProperty(value="legalArrangementEntityReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityReference(String legalArrangementEntityReference) {
        this.legalArrangementEntityReference = legalArrangementEntityReference;
    }

    public LegalArrangementEntityDetail legalArrangementMembers(List<LegalArrangementMembersEnum> legalArrangementMembers) {
        this.legalArrangementMembers = legalArrangementMembers;
        return this;
    }

    public LegalArrangementEntityDetail addLegalArrangementMembersItem(LegalArrangementMembersEnum legalArrangementMembersItem) {
        if (this.legalArrangementMembers == null) {
            this.legalArrangementMembers = new ArrayList<LegalArrangementMembersEnum>();
        }
        this.legalArrangementMembers.add(legalArrangementMembersItem);
        return this;
    }

    @ApiModelProperty(value="An array containing the roles of the entity in the legal arrangement.  The possible values depend on the legal arrangement `type`.  - For `type` **Association**: **ControllingPerson** and **Shareholder**.  - For `type` **Partnership**: **Partner** and **Shareholder**.  - For `type` **Trust**: **Trustee**, **Settlor**, **Protector**, **Beneficiary**,  and **Shareholder**.  ")
    @JsonProperty(value="legalArrangementMembers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalArrangementMembersEnum> getLegalArrangementMembers() {
        return this.legalArrangementMembers;
    }

    @JsonProperty(value="legalArrangementMembers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementMembers(List<LegalArrangementMembersEnum> legalArrangementMembers) {
        this.legalArrangementMembers = legalArrangementMembers;
    }

    public LegalArrangementEntityDetail legalEntityType(LegalEntityTypeEnum legalEntityType) {
        this.legalEntityType = legalEntityType;
        return this;
    }

    @ApiModelProperty(value="The legal entity type.  Possible values: **Business**, **Individual**, **NonProfit**, **PublicCompany**, or **Partnership**. ")
    @JsonProperty(value="legalEntityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LegalEntityTypeEnum getLegalEntityType() {
        return this.legalEntityType;
    }

    @JsonProperty(value="legalEntityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityType(LegalEntityTypeEnum legalEntityType) {
        this.legalEntityType = legalEntityType;
    }

    public LegalArrangementEntityDetail phoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public LegalArrangementEntityDetail webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the website of the contact.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalArrangementEntityDetail legalArrangementEntityDetail = (LegalArrangementEntityDetail)o;
        return Objects.equals(this.address, legalArrangementEntityDetail.address) && Objects.equals(this.businessDetails, legalArrangementEntityDetail.businessDetails) && Objects.equals(this.email, legalArrangementEntityDetail.email) && Objects.equals(this.fullPhoneNumber, legalArrangementEntityDetail.fullPhoneNumber) && Objects.equals(this.individualDetails, legalArrangementEntityDetail.individualDetails) && Objects.equals(this.legalArrangementEntityCode, legalArrangementEntityDetail.legalArrangementEntityCode) && Objects.equals(this.legalArrangementEntityReference, legalArrangementEntityDetail.legalArrangementEntityReference) && Objects.equals(this.legalArrangementMembers, legalArrangementEntityDetail.legalArrangementMembers) && Objects.equals((Object)this.legalEntityType, (Object)legalArrangementEntityDetail.legalEntityType) && Objects.equals(this.phoneNumber, legalArrangementEntityDetail.phoneNumber) && Objects.equals(this.webAddress, legalArrangementEntityDetail.webAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.businessDetails, this.email, this.fullPhoneNumber, this.individualDetails, this.legalArrangementEntityCode, this.legalArrangementEntityReference, this.legalArrangementMembers, this.legalEntityType, this.phoneNumber, this.webAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalArrangementEntityDetail {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessDetails: ").append(this.toIndentedString(this.businessDetails)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    individualDetails: ").append(this.toIndentedString(this.individualDetails)).append("\n");
        sb.append("    legalArrangementEntityCode: ").append(this.toIndentedString(this.legalArrangementEntityCode)).append("\n");
        sb.append("    legalArrangementEntityReference: ").append(this.toIndentedString(this.legalArrangementEntityReference)).append("\n");
        sb.append("    legalArrangementMembers: ").append(this.toIndentedString(this.legalArrangementMembers)).append("\n");
        sb.append("    legalEntityType: ").append(this.toIndentedString((Object)this.legalEntityType)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalArrangementEntityDetail fromJson(String jsonString) throws JsonProcessingException {
        return (LegalArrangementEntityDetail)JSON.getMapper().readValue(jsonString, LegalArrangementEntityDetail.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum LegalEntityTypeEnum {
        BUSINESS("Business"),
        INDIVIDUAL("Individual"),
        NONPROFIT("NonProfit"),
        PARTNERSHIP("Partnership"),
        PUBLICCOMPANY("PublicCompany");

        private String value;

        private LegalEntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LegalEntityTypeEnum fromValue(String value) {
            for (LegalEntityTypeEnum b : LegalEntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LegalArrangementMembersEnum {
        BENEFICIARY("Beneficiary"),
        CONTROLLINGPERSON("ControllingPerson"),
        PARTNER("Partner"),
        PROTECTOR("Protector"),
        SETTLOR("Settlor"),
        SHAREHOLDER("Shareholder"),
        TRUSTEE("Trustee");

        private String value;

        private LegalArrangementMembersEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LegalArrangementMembersEnum fromValue(String value) {
            for (LegalArrangementMembersEnum b : LegalArrangementMembersEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

