/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Counterparty;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"balanceAccountId", "balancePlatform", "category", "counterparty", "country", "currency", "priorities"})
public class TransferRouteRequest {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private Counterparty counterparty;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_PRIORITIES = "priorities";
    private List<PrioritiesEnum> priorities;

    public TransferRouteRequest balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public TransferRouteRequest balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public TransferRouteRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferRouteRequest counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public TransferRouteRequest country(String country) {
        this.country = country;
        return this;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public TransferRouteRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public TransferRouteRequest priorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        return this;
    }

    public TransferRouteRequest addPrioritiesItem(PrioritiesEnum prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<PrioritiesEnum>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PrioritiesEnum> getPriorities() {
        return this.priorities;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRouteRequest transferRouteRequest = (TransferRouteRequest)o;
        return Objects.equals(this.balanceAccountId, transferRouteRequest.balanceAccountId) && Objects.equals(this.balancePlatform, transferRouteRequest.balancePlatform) && Objects.equals((Object)this.category, (Object)transferRouteRequest.category) && Objects.equals(this.counterparty, transferRouteRequest.counterparty) && Objects.equals(this.country, transferRouteRequest.country) && Objects.equals(this.currency, transferRouteRequest.currency) && Objects.equals(this.priorities, transferRouteRequest.priorities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceAccountId, this.balancePlatform, this.category, this.counterparty, this.country, this.currency, this.priorities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRouteRequest {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferRouteRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TransferRouteRequest)JSON.getMapper().readValue(jsonString, TransferRouteRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PrioritiesEnum {
        CROSSBORDER(String.valueOf("crossBorder")),
        FAST(String.valueOf("fast")),
        INSTANT(String.valueOf("instant")),
        INTERNAL(String.valueOf("internal")),
        REGULAR(String.valueOf("regular")),
        WIRE(String.valueOf("wire"));

        private static final Logger LOG;
        private String value;

        private PrioritiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrioritiesEnum fromValue(String value) {
            for (PrioritiesEnum b : PrioritiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PrioritiesEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PrioritiesEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PrioritiesEnum.class.getName());
        }
    }

    public static enum CategoryEnum {
        BANK(String.valueOf("bank"));

        private static final Logger LOG;
        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CategoryEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CategoryEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CategoryEnum.class.getName());
        }
    }
}

