/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.CapitalBalance;
import com.adyen.model.balanceplatform.GrantLimit;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"balances", "fundingBalanceAccountId", "id", "limits"})
public class CapitalGrantAccount {
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<CapitalBalance> balances;
    public static final String JSON_PROPERTY_FUNDING_BALANCE_ACCOUNT_ID = "fundingBalanceAccountId";
    private String fundingBalanceAccountId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIMITS = "limits";
    private List<GrantLimit> limits;

    public CapitalGrantAccount balances(List<CapitalBalance> balances) {
        this.balances = balances;
        return this;
    }

    public CapitalGrantAccount addBalancesItem(CapitalBalance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<CapitalBalance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapitalBalance> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<CapitalBalance> balances) {
        this.balances = balances;
    }

    public CapitalGrantAccount fundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
        return this;
    }

    @JsonProperty(value="fundingBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingBalanceAccountId() {
        return this.fundingBalanceAccountId;
    }

    @JsonProperty(value="fundingBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
    }

    public CapitalGrantAccount id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CapitalGrantAccount limits(List<GrantLimit> limits) {
        this.limits = limits;
        return this;
    }

    public CapitalGrantAccount addLimitsItem(GrantLimit limitsItem) {
        if (this.limits == null) {
            this.limits = new ArrayList<GrantLimit>();
        }
        this.limits.add(limitsItem);
        return this;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GrantLimit> getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimits(List<GrantLimit> limits) {
        this.limits = limits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrantAccount capitalGrantAccount = (CapitalGrantAccount)o;
        return Objects.equals(this.balances, capitalGrantAccount.balances) && Objects.equals(this.fundingBalanceAccountId, capitalGrantAccount.fundingBalanceAccountId) && Objects.equals(this.id, capitalGrantAccount.id) && Objects.equals(this.limits, capitalGrantAccount.limits);
    }

    public int hashCode() {
        return Objects.hash(this.balances, this.fundingBalanceAccountId, this.id, this.limits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrantAccount {\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    fundingBalanceAccountId: ").append(this.toIndentedString(this.fundingBalanceAccountId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CapitalGrantAccount fromJson(String jsonString) throws JsonProcessingException {
        return (CapitalGrantAccount)JSON.getMapper().readValue(jsonString, CapitalGrantAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

