/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.acswebhooks;

import com.adyen.model.acswebhooks.AuthenticationNotificationRequest;
import com.adyen.model.acswebhooks.JSON;
import com.adyen.model.acswebhooks.RelayedAuthenticationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class AcsWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(AcsWebhooksHandler.class.getName());
    private final String payload;

    public AcsWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<AuthenticationNotificationRequest> getAuthenticationNotificationRequest() {
        Optional<AuthenticationNotificationRequest> optionalAuthenticationNotificationRequest = this.getOptionalField(AuthenticationNotificationRequest.class);
        if (optionalAuthenticationNotificationRequest.isPresent()) {
            for (AuthenticationNotificationRequest.TypeEnum value : AuthenticationNotificationRequest.TypeEnum.values()) {
                if (!value.equals((Object)optionalAuthenticationNotificationRequest.get().getType())) continue;
                return optionalAuthenticationNotificationRequest;
            }
        }
        return Optional.empty();
    }

    public Optional<RelayedAuthenticationRequest> getRelayedAuthenticationRequest() {
        Optional<RelayedAuthenticationRequest> optionalRelayedAuthenticationRequest = this.getOptionalField(RelayedAuthenticationRequest.class);
        if (optionalRelayedAuthenticationRequest.isPresent()) {
            for (RelayedAuthenticationRequest.TypeEnum value : RelayedAuthenticationRequest.TypeEnum.values()) {
                if (!value.equals((Object)optionalRelayedAuthenticationRequest.get().getType())) continue;
                return optionalRelayedAuthenticationRequest;
            }
        }
        return Optional.empty();
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

