/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "merchantAccount", "paymentMethod", "recurringDetailReference", "reference", "shopperInteraction", "shopperReference", "sourcePaymentMethod", "store"})
public class StoredValueBalanceMergeRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private Map<String, String> paymentMethod = new HashMap<String, String>();
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SOURCE_PAYMENT_METHOD = "sourcePaymentMethod";
    private Map<String, String> sourcePaymentMethod = new HashMap<String, String>();
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public StoredValueBalanceMergeRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public StoredValueBalanceMergeRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredValueBalanceMergeRequest paymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public StoredValueBalanceMergeRequest putPaymentMethodItem(String key, String paymentMethodItem) {
        this.paymentMethod.put(key, paymentMethodItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The collection that contains the type of the payment method and its specific information if available")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public StoredValueBalanceMergeRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public StoredValueBalanceMergeRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoredValueBalanceMergeRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public StoredValueBalanceMergeRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoredValueBalanceMergeRequest sourcePaymentMethod(Map<String, String> sourcePaymentMethod) {
        this.sourcePaymentMethod = sourcePaymentMethod;
        return this;
    }

    public StoredValueBalanceMergeRequest putSourcePaymentMethodItem(String key, String sourcePaymentMethodItem) {
        this.sourcePaymentMethod.put(key, sourcePaymentMethodItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The collection that contains the source payment method and its specific information if available. Note that type should not be included since it is inferred from the (target) payment method")
    @JsonProperty(value="sourcePaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getSourcePaymentMethod() {
        return this.sourcePaymentMethod;
    }

    @JsonProperty(value="sourcePaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePaymentMethod(Map<String, String> sourcePaymentMethod) {
        this.sourcePaymentMethod = sourcePaymentMethod;
    }

    public StoredValueBalanceMergeRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The physical store, for which this payment is processed.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueBalanceMergeRequest storedValueBalanceMergeRequest = (StoredValueBalanceMergeRequest)o;
        return Objects.equals(this.amount, storedValueBalanceMergeRequest.amount) && Objects.equals(this.merchantAccount, storedValueBalanceMergeRequest.merchantAccount) && Objects.equals(this.paymentMethod, storedValueBalanceMergeRequest.paymentMethod) && Objects.equals(this.recurringDetailReference, storedValueBalanceMergeRequest.recurringDetailReference) && Objects.equals(this.reference, storedValueBalanceMergeRequest.reference) && Objects.equals((Object)this.shopperInteraction, (Object)storedValueBalanceMergeRequest.shopperInteraction) && Objects.equals(this.shopperReference, storedValueBalanceMergeRequest.shopperReference) && Objects.equals(this.sourcePaymentMethod, storedValueBalanceMergeRequest.sourcePaymentMethod) && Objects.equals(this.store, storedValueBalanceMergeRequest.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.merchantAccount, this.paymentMethod, this.recurringDetailReference, this.reference, this.shopperInteraction, this.shopperReference, this.sourcePaymentMethod, this.store});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueBalanceMergeRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    sourcePaymentMethod: ").append(this.toIndentedString(this.sourcePaymentMethod)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredValueBalanceMergeRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueBalanceMergeRequest)JSON.getMapper().readValue(jsonString, StoredValueBalanceMergeRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

