/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"number", "phoneCountryCode", "type"})
public class PhoneNumber {
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_PHONE_COUNTRY_CODE = "phoneCountryCode";
    private String phoneCountryCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PhoneNumber number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The full phone number, including the country code. For example, **+3112345678**.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public PhoneNumber phoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
        return this;
    }

    @ApiModelProperty(value="The two-letter [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code prefix of the phone number. For example, **US** or **NL**.  The value of the `phoneCountryCode` is determined by the country code digit(s) of `phone.number`")
    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneCountryCode() {
        return this.phoneCountryCode;
    }

    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
    }

    public PhoneNumber type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber phoneNumber = (PhoneNumber)o;
        return Objects.equals(this.number, phoneNumber.number) && Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) && Objects.equals(this.type, phoneNumber.type);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.phoneCountryCode, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumber {\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    phoneCountryCode: ").append(this.toIndentedString(this.phoneCountryCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PhoneNumber fromJson(String jsonString) throws JsonProcessingException {
        return (PhoneNumber)JSON.getMapper().readValue(jsonString, PhoneNumber.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

