/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "paymentMethodData", "type"})
public class PaymentMethodGroup {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_DATA = "paymentMethodData";
    private String paymentMethodData;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PaymentMethodGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the group.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PaymentMethodGroup paymentMethodData(String paymentMethodData) {
        this.paymentMethodData = paymentMethodData;
        return this;
    }

    @ApiModelProperty(value="Echo data to be used if the payment method is displayed as part of this group.")
    @JsonProperty(value="paymentMethodData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodData() {
        return this.paymentMethodData;
    }

    @JsonProperty(value="paymentMethodData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodData(String paymentMethodData) {
        this.paymentMethodData = paymentMethodData;
    }

    public PaymentMethodGroup type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The unique code of the group.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodGroup paymentMethodGroup = (PaymentMethodGroup)o;
        return Objects.equals(this.name, paymentMethodGroup.name) && Objects.equals(this.paymentMethodData, paymentMethodGroup.paymentMethodData) && Objects.equals(this.type, paymentMethodGroup.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.paymentMethodData, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodGroup {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentMethodData: ").append(this.toIndentedString(this.paymentMethodData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethodGroup fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethodGroup)JSON.getMapper().readValue(jsonString, PaymentMethodGroup.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

