/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"estimatedDays", "maximumDays"})
public class RepaymentTerm {
    public static final String JSON_PROPERTY_ESTIMATED_DAYS = "estimatedDays";
    private Integer estimatedDays;
    public static final String JSON_PROPERTY_MAXIMUM_DAYS = "maximumDays";
    private Integer maximumDays;

    public RepaymentTerm estimatedDays(Integer estimatedDays) {
        this.estimatedDays = estimatedDays;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated term for repaying the grant, in days.")
    @JsonProperty(value="estimatedDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEstimatedDays() {
        return this.estimatedDays;
    }

    @JsonProperty(value="estimatedDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedDays(Integer estimatedDays) {
        this.estimatedDays = estimatedDays;
    }

    public RepaymentTerm maximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
        return this;
    }

    @ApiModelProperty(value="The maximum term for repaying the grant, in days. Only applies when `contractType` is **loan**.")
    @JsonProperty(value="maximumDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaximumDays() {
        return this.maximumDays;
    }

    @JsonProperty(value="maximumDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepaymentTerm repaymentTerm = (RepaymentTerm)o;
        return Objects.equals(this.estimatedDays, repaymentTerm.estimatedDays) && Objects.equals(this.maximumDays, repaymentTerm.maximumDays);
    }

    public int hashCode() {
        return Objects.hash(this.estimatedDays, this.maximumDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepaymentTerm {\n");
        sb.append("    estimatedDays: ").append(this.toIndentedString(this.estimatedDays)).append("\n");
        sb.append("    maximumDays: ").append(this.toIndentedString(this.maximumDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RepaymentTerm fromJson(String jsonString) throws JsonProcessingException {
        return (RepaymentTerm)JSON.getMapper().readValue(jsonString, RepaymentTerm.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

