/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"encryptedKey", "encryptedPinBlock", "paymentInstrumentId", "token"})
public class PinChangeRequest {
    public static final String JSON_PROPERTY_ENCRYPTED_KEY = "encryptedKey";
    private String encryptedKey;
    public static final String JSON_PROPERTY_ENCRYPTED_PIN_BLOCK = "encryptedPinBlock";
    private String encryptedPinBlock;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;

    public PinChangeRequest encryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The symmetric session key that you encrypted with the [public key](https://docs.adyen.com/api-explorer/balanceplatform/2/get/publicKey) that you received from Adyen.")
    @JsonProperty(value="encryptedKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    @JsonProperty(value="encryptedKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public PinChangeRequest encryptedPinBlock(String encryptedPinBlock) {
        this.encryptedPinBlock = encryptedPinBlock;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted [PIN block](https://www.pcisecuritystandards.org/glossary/pin-block).")
    @JsonProperty(value="encryptedPinBlock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    @JsonProperty(value="encryptedPinBlock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedPinBlock(String encryptedPinBlock) {
        this.encryptedPinBlock = encryptedPinBlock;
    }

    public PinChangeRequest paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the payment instrument, which is the card for which you are managing the PIN.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public PinChangeRequest token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="The 16-digit token that you used to generate the `encryptedPinBlock`.")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinChangeRequest pinChangeRequest = (PinChangeRequest)o;
        return Objects.equals(this.encryptedKey, pinChangeRequest.encryptedKey) && Objects.equals(this.encryptedPinBlock, pinChangeRequest.encryptedPinBlock) && Objects.equals(this.paymentInstrumentId, pinChangeRequest.paymentInstrumentId) && Objects.equals(this.token, pinChangeRequest.token);
    }

    public int hashCode() {
        return Objects.hash(this.encryptedKey, this.encryptedPinBlock, this.paymentInstrumentId, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PinChangeRequest {\n");
        sb.append("    encryptedKey: ").append(this.toIndentedString(this.encryptedKey)).append("\n");
        sb.append("    encryptedPinBlock: ").append(this.toIndentedString(this.encryptedPinBlock)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PinChangeRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PinChangeRequest)JSON.getMapper().readValue(jsonString, PinChangeRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

