/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"operation", "value"})
public class DayOfWeekRestriction {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private String operation;
    public static final String JSON_PROPERTY_VALUE = "value";
    private List<ValueEnum> value = null;

    public DayOfWeekRestriction operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines how the condition must be evaluated.")
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public DayOfWeekRestriction value(List<ValueEnum> value) {
        this.value = value;
        return this;
    }

    public DayOfWeekRestriction addValueItem(ValueEnum valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<ValueEnum>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="List of days of the week.  Possible values: **monday**, **tuesday**, **wednesday**, **thursday**, **friday**, **saturday**, **sunday**.  ")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ValueEnum> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(List<ValueEnum> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayOfWeekRestriction dayOfWeekRestriction = (DayOfWeekRestriction)o;
        return Objects.equals(this.operation, dayOfWeekRestriction.operation) && Objects.equals(this.value, dayOfWeekRestriction.value);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DayOfWeekRestriction {\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DayOfWeekRestriction fromJson(String jsonString) throws JsonProcessingException {
        return (DayOfWeekRestriction)JSON.getMapper().readValue(jsonString, DayOfWeekRestriction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ValueEnum {
        FRIDAY("friday"),
        MONDAY("monday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        THURSDAY("thursday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday");

        private String value;

        private ValueEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValueEnum fromValue(String value) {
            for (ValueEnum b : ValueEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

