/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"formFactor"})
public class BankAccountModel {
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private FormFactorEnum formFactor;

    public BankAccountModel formFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="Business accounts with a `formFactor` value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the `formFactor` value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormFactorEnum getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccountModel bankAccountModel = (BankAccountModel)o;
        return Objects.equals((Object)this.formFactor, (Object)bankAccountModel.formFactor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formFactor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccountModel {\n");
        sb.append("    formFactor: ").append(this.toIndentedString((Object)this.formFactor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BankAccountModel fromJson(String jsonString) throws JsonProcessingException {
        return (BankAccountModel)JSON.getMapper().readValue(jsonString, BankAccountModel.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FormFactorEnum {
        PHYSICAL("physical"),
        UNKNOWN("unknown"),
        VIRTUAL("virtual");

        private String value;

        private FormFactorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormFactorEnum fromValue(String value) {
            for (FormFactorEnum b : FormFactorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

