/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.ShareholderContact;
import com.adyen.model.marketpayaccount.SignatoryContact;
import com.adyen.model.marketpayaccount.UltimateParentCompany;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"doingBusinessAs", "legalBusinessName", "listedUltimateParentCompany", "registrationNumber", "shareholders", "signatories", "stockExchange", "stockNumber", "stockTicker", "taxId"})
public class BusinessDetails {
    public static final String JSON_PROPERTY_DOING_BUSINESS_AS = "doingBusinessAs";
    private String doingBusinessAs;
    public static final String JSON_PROPERTY_LEGAL_BUSINESS_NAME = "legalBusinessName";
    private String legalBusinessName;
    public static final String JSON_PROPERTY_LISTED_ULTIMATE_PARENT_COMPANY = "listedUltimateParentCompany";
    private List<UltimateParentCompany> listedUltimateParentCompany = null;
    public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
    private String registrationNumber;
    public static final String JSON_PROPERTY_SHAREHOLDERS = "shareholders";
    private List<ShareholderContact> shareholders = null;
    public static final String JSON_PROPERTY_SIGNATORIES = "signatories";
    private List<SignatoryContact> signatories = null;
    public static final String JSON_PROPERTY_STOCK_EXCHANGE = "stockExchange";
    private String stockExchange;
    public static final String JSON_PROPERTY_STOCK_NUMBER = "stockNumber";
    private String stockNumber;
    public static final String JSON_PROPERTY_STOCK_TICKER = "stockTicker";
    private String stockTicker;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;

    public BusinessDetails doingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
        return this;
    }

    @ApiModelProperty(value="The registered name of the company (if it differs from the legal name of the company).")
    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDoingBusinessAs() {
        return this.doingBusinessAs;
    }

    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDoingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
    }

    public BusinessDetails legalBusinessName(String legalBusinessName) {
        this.legalBusinessName = legalBusinessName;
        return this;
    }

    @ApiModelProperty(value="The legal name of the company.")
    @JsonProperty(value="legalBusinessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalBusinessName() {
        return this.legalBusinessName;
    }

    @JsonProperty(value="legalBusinessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalBusinessName(String legalBusinessName) {
        this.legalBusinessName = legalBusinessName;
    }

    public BusinessDetails listedUltimateParentCompany(List<UltimateParentCompany> listedUltimateParentCompany) {
        this.listedUltimateParentCompany = listedUltimateParentCompany;
        return this;
    }

    public BusinessDetails addListedUltimateParentCompanyItem(UltimateParentCompany listedUltimateParentCompanyItem) {
        if (this.listedUltimateParentCompany == null) {
            this.listedUltimateParentCompany = new ArrayList<UltimateParentCompany>();
        }
        this.listedUltimateParentCompany.add(listedUltimateParentCompanyItem);
        return this;
    }

    @ApiModelProperty(value="Information about the parent public company. Required if the account holder is 100% owned by a publicly listed company.")
    @JsonProperty(value="listedUltimateParentCompany")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UltimateParentCompany> getListedUltimateParentCompany() {
        return this.listedUltimateParentCompany;
    }

    @JsonProperty(value="listedUltimateParentCompany")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setListedUltimateParentCompany(List<UltimateParentCompany> listedUltimateParentCompany) {
        this.listedUltimateParentCompany = listedUltimateParentCompany;
    }

    public BusinessDetails registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="The registration number of the company.")
    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public BusinessDetails shareholders(List<ShareholderContact> shareholders) {
        this.shareholders = shareholders;
        return this;
    }

    public BusinessDetails addShareholdersItem(ShareholderContact shareholdersItem) {
        if (this.shareholders == null) {
            this.shareholders = new ArrayList<ShareholderContact>();
        }
        this.shareholders.add(shareholdersItem);
        return this;
    }

    @ApiModelProperty(value="Array containing information about individuals associated with the account holder either through ownership or control. For details about how you can identify them, refer to [our verification guide](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process#identify-ubos).")
    @JsonProperty(value="shareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ShareholderContact> getShareholders() {
        return this.shareholders;
    }

    @JsonProperty(value="shareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholders(List<ShareholderContact> shareholders) {
        this.shareholders = shareholders;
    }

    public BusinessDetails signatories(List<SignatoryContact> signatories) {
        this.signatories = signatories;
        return this;
    }

    public BusinessDetails addSignatoriesItem(SignatoryContact signatoriesItem) {
        if (this.signatories == null) {
            this.signatories = new ArrayList<SignatoryContact>();
        }
        this.signatories.add(signatoriesItem);
        return this;
    }

    @ApiModelProperty(value="Signatories associated with the company. Each array entry should represent one signatory.")
    @JsonProperty(value="signatories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SignatoryContact> getSignatories() {
        return this.signatories;
    }

    @JsonProperty(value="signatories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatories(List<SignatoryContact> signatories) {
        this.signatories = signatories;
    }

    public BusinessDetails stockExchange(String stockExchange) {
        this.stockExchange = stockExchange;
        return this;
    }

    @ApiModelProperty(value="Market Identifier Code (MIC).")
    @JsonProperty(value="stockExchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStockExchange() {
        return this.stockExchange;
    }

    @JsonProperty(value="stockExchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStockExchange(String stockExchange) {
        this.stockExchange = stockExchange;
    }

    public BusinessDetails stockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
        return this;
    }

    @ApiModelProperty(value="International Securities Identification Number (ISIN).")
    @JsonProperty(value="stockNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStockNumber() {
        return this.stockNumber;
    }

    @JsonProperty(value="stockNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
    }

    public BusinessDetails stockTicker(String stockTicker) {
        this.stockTicker = stockTicker;
        return this;
    }

    @ApiModelProperty(value="Stock Ticker symbol.")
    @JsonProperty(value="stockTicker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStockTicker() {
        return this.stockTicker;
    }

    @JsonProperty(value="stockTicker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStockTicker(String stockTicker) {
        this.stockTicker = stockTicker;
    }

    public BusinessDetails taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax ID of the company.")
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessDetails businessDetails = (BusinessDetails)o;
        return Objects.equals(this.doingBusinessAs, businessDetails.doingBusinessAs) && Objects.equals(this.legalBusinessName, businessDetails.legalBusinessName) && Objects.equals(this.listedUltimateParentCompany, businessDetails.listedUltimateParentCompany) && Objects.equals(this.registrationNumber, businessDetails.registrationNumber) && Objects.equals(this.shareholders, businessDetails.shareholders) && Objects.equals(this.signatories, businessDetails.signatories) && Objects.equals(this.stockExchange, businessDetails.stockExchange) && Objects.equals(this.stockNumber, businessDetails.stockNumber) && Objects.equals(this.stockTicker, businessDetails.stockTicker) && Objects.equals(this.taxId, businessDetails.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.doingBusinessAs, this.legalBusinessName, this.listedUltimateParentCompany, this.registrationNumber, this.shareholders, this.signatories, this.stockExchange, this.stockNumber, this.stockTicker, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessDetails {\n");
        sb.append("    doingBusinessAs: ").append(this.toIndentedString(this.doingBusinessAs)).append("\n");
        sb.append("    legalBusinessName: ").append(this.toIndentedString(this.legalBusinessName)).append("\n");
        sb.append("    listedUltimateParentCompany: ").append(this.toIndentedString(this.listedUltimateParentCompany)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    shareholders: ").append(this.toIndentedString(this.shareholders)).append("\n");
        sb.append("    signatories: ").append(this.toIndentedString(this.signatories)).append("\n");
        sb.append("    stockExchange: ").append(this.toIndentedString(this.stockExchange)).append("\n");
        sb.append("    stockNumber: ").append(this.toIndentedString(this.stockNumber)).append("\n");
        sb.append("    stockTicker: ").append(this.toIndentedString(this.stockTicker)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BusinessDetails fromJson(String jsonString) throws JsonProcessingException {
        return (BusinessDetails)JSON.getMapper().readValue(jsonString, BusinessDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

