/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.CustomNotification;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"notification", "types"})
public class TestWebhookRequest {
    public static final String JSON_PROPERTY_NOTIFICATION = "notification";
    private CustomNotification notification;
    public static final String JSON_PROPERTY_TYPES = "types";
    private List<String> types = null;

    public TestWebhookRequest notification(CustomNotification notification) {
        this.notification = notification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="notification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomNotification getNotification() {
        return this.notification;
    }

    @JsonProperty(value="notification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotification(CustomNotification notification) {
        this.notification = notification;
    }

    public TestWebhookRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    public TestWebhookRequest addTypesItem(String typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="List of event codes for which to send test notifications. Only the webhook types below are supported.   Possible values if webhook `type`: **standard**:  * **AUTHORISATION** * **CHARGEBACK_REVERSED** * **ORDER_CLOSED** * **ORDER_OPENED** * **PAIDOUT_REVERSED** * **PAYOUT_THIRDPARTY** * **REFUNDED_REVERSED** * **REFUND_WITH_DATA** * **REPORT_AVAILABLE** * **CUSTOM** - set your custom notification fields in the [`notification`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/companies/{companyId}/webhooks/{webhookId}/test__reqParam_notification) object.  Possible values if webhook `type`: **banktransfer-notification**:  * **PENDING**  Possible values if webhook `type`: **report-notification**:  * **REPORT_AVAILABLE**  Possible values if webhook `type`: **ideal-notification**:  * **AUTHORISATION**  Possible values if webhook `type`: **pending-notification**:  * **PENDING** ")
    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTypes() {
        return this.types;
    }

    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestWebhookRequest testWebhookRequest = (TestWebhookRequest)o;
        return Objects.equals(this.notification, testWebhookRequest.notification) && Objects.equals(this.types, testWebhookRequest.types);
    }

    public int hashCode() {
        return Objects.hash(this.notification, this.types);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestWebhookRequest {\n");
        sb.append("    notification: ").append(this.toIndentedString(this.notification)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TestWebhookRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TestWebhookRequest)JSON.getMapper().readValue(jsonString, TestWebhookRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

