/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"credit", "debit", "deferredDebit", "prepaid", "unknown"})
public class SupportedCardTypes {
    public static final String JSON_PROPERTY_CREDIT = "credit";
    private Boolean credit;
    public static final String JSON_PROPERTY_DEBIT = "debit";
    private Boolean debit;
    public static final String JSON_PROPERTY_DEFERRED_DEBIT = "deferredDebit";
    private Boolean deferredDebit;
    public static final String JSON_PROPERTY_PREPAID = "prepaid";
    private Boolean prepaid;
    public static final String JSON_PROPERTY_UNKNOWN = "unknown";
    private Boolean unknown;

    public SupportedCardTypes credit(Boolean credit) {
        this.credit = credit;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to accept credit cards.")
    @JsonProperty(value="credit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCredit() {
        return this.credit;
    }

    @JsonProperty(value="credit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredit(Boolean credit) {
        this.credit = credit;
    }

    public SupportedCardTypes debit(Boolean debit) {
        this.debit = debit;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to accept debit cards.")
    @JsonProperty(value="debit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDebit() {
        return this.debit;
    }

    @JsonProperty(value="debit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDebit(Boolean debit) {
        this.debit = debit;
    }

    public SupportedCardTypes deferredDebit(Boolean deferredDebit) {
        this.deferredDebit = deferredDebit;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to accept cards that allow deferred debit.")
    @JsonProperty(value="deferredDebit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeferredDebit() {
        return this.deferredDebit;
    }

    @JsonProperty(value="deferredDebit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeferredDebit(Boolean deferredDebit) {
        this.deferredDebit = deferredDebit;
    }

    public SupportedCardTypes prepaid(Boolean prepaid) {
        this.prepaid = prepaid;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to accept prepaid cards.")
    @JsonProperty(value="prepaid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrepaid() {
        return this.prepaid;
    }

    @JsonProperty(value="prepaid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrepaid(Boolean prepaid) {
        this.prepaid = prepaid;
    }

    public SupportedCardTypes unknown(Boolean unknown) {
        this.unknown = unknown;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to accept card types for which the terminal can't determine the funding source while offline.")
    @JsonProperty(value="unknown")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUnknown() {
        return this.unknown;
    }

    @JsonProperty(value="unknown")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnknown(Boolean unknown) {
        this.unknown = unknown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedCardTypes supportedCardTypes = (SupportedCardTypes)o;
        return Objects.equals(this.credit, supportedCardTypes.credit) && Objects.equals(this.debit, supportedCardTypes.debit) && Objects.equals(this.deferredDebit, supportedCardTypes.deferredDebit) && Objects.equals(this.prepaid, supportedCardTypes.prepaid) && Objects.equals(this.unknown, supportedCardTypes.unknown);
    }

    public int hashCode() {
        return Objects.hash(this.credit, this.debit, this.deferredDebit, this.prepaid, this.unknown);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedCardTypes {\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    debit: ").append(this.toIndentedString(this.debit)).append("\n");
        sb.append("    deferredDebit: ").append(this.toIndentedString(this.deferredDebit)).append("\n");
        sb.append("    prepaid: ").append(this.toIndentedString(this.prepaid)).append("\n");
        sb.append("    unknown: ").append(this.toIndentedString(this.unknown)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SupportedCardTypes fromJson(String jsonString) throws JsonProcessingException {
        return (SupportedCardTypes)JSON.getMapper().readValue(jsonString, SupportedCardTypes.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

