/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.utils;

import java.util.HashMap;
import java.util.Map;

public class TimingTool {
    private Map<String, Long> startTimes = new HashMap<String, Long>();
    private Map<String, Double> timings = new HashMap<String, Double>();

    public String timeStart(String id) {
        if (!this.startTimes.containsKey(id)) {
            this.startTimes.put(id, System.nanoTime());
        }
        return id;
    }

    public double timeEnd(String id) {
        if (!this.startTimes.containsKey(id)) {
            return -1.0;
        }
        double timing = (double)(System.nanoTime() - this.startTimes.get(id)) / 1000000.0;
        this.timings.put(id, timing);
        return timing;
    }

    public Map<String, Double> getTimings() {
        return this.timings;
    }

    public double getTiming(String id) {
        return this.timings.get(id);
    }

    public void reset() {
        this.startTimes = new HashMap<String, Long>();
        this.timings = new HashMap<String, Double>();
    }
}

