/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.utils;

public class HashingUtils {
    private static final int DEFAULT_SEED_VALUE = 0;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    public static final int CHARACTER_SIZE = 16;
    public static final int BYTE_SIZE = 8;
    public static final int CHARS_BYTES = 2;

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int hashUnencodedChars(CharSequence input) {
        return HashingUtils.hashUnencodedChars(input, 0);
    }

    public static int hashUnencodedChars(CharSequence input, int seed) {
        int h1 = seed;
        for (int i = 1; i < input.length(); i += 2) {
            int k1 = input.charAt(i - 1) | input.charAt(i) << 16;
            k1 = HashingUtils.mixK1(k1);
            h1 = HashingUtils.mixH1(h1, k1);
        }
        if ((input.length() & 1) == 1) {
            int k1 = input.charAt(input.length() - 1);
            k1 = HashingUtils.mixK1(k1);
            h1 ^= k1;
        }
        return HashingUtils.fmix(h1, 2 * input.length());
    }
}

