/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.utils;

import com.adobe.target.edge.client.model.TargetCookie;
import com.adobe.target.edge.client.service.VisitorProvider;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class CookieUtils {
    private static final String COOKIE_VALUE_SEPARATOR = "|";
    private static final String INTERNAL_COOKIE_SERIALIZATION_SEPARATOR = "#";
    public static final String SESSION_ID_COOKIE_NAME = "session";
    public static final String DEVICE_ID_COOKIE_NAME = "PC";
    private static final int SESSION_ID_COOKIE_MAX_AGE = 1860;
    private static final int DEVICE_ID_COOKIE_MAX_AGE = 63244800;
    private static final int CLUSTER_LOCATION_HINT_MAX_AGE = 1860;
    private static Set<String> TARGET_COOKIE_NAMES;

    public static String getDeviceId(Map<String, TargetCookie> parseCookies) {
        String returnValue = null;
        TargetCookie cookie = parseCookies.get(DEVICE_ID_COOKIE_NAME);
        if (cookie != null) {
            returnValue = cookie.getValue();
        }
        return returnValue;
    }

    public static String getSessionId(Map<String, TargetCookie> parseCookies) {
        TargetCookie cookie = parseCookies.get(SESSION_ID_COOKIE_NAME);
        String sessionId = cookie != null && !StringUtils.isEmpty(cookie.getValue()) ? cookie.getValue() : UUID.randomUUID().toString().replaceAll("-", "");
        return sessionId;
    }

    public static Map<String, String> parseTargetCookies(String targetCookie) {
        String[] rawInternalCookies;
        if (StringUtils.isEmpty(targetCookie)) {
            return Collections.EMPTY_MAP;
        }
        int nowInSeconds = CookieUtils.getNowInSeconds();
        HashMap<String, String> internalTargetCookies = new HashMap<String, String>();
        for (String rawInternalCookie : rawInternalCookies = targetCookie.split(Pattern.quote(COOKIE_VALUE_SEPARATOR))) {
            if (StringUtils.isEmpty(rawInternalCookie)) break;
            TargetCookie internalCookie = CookieUtils.deserializeInternalCookie(rawInternalCookie);
            if (internalCookie == null || internalCookie.getMaxAge() <= nowInSeconds) continue;
            internalTargetCookies.put(internalCookie.getName(), internalCookie.getValue());
        }
        return internalTargetCookies;
    }

    private static TargetCookie deserializeInternalCookie(String cookie) {
        String[] cookieTokens = cookie.split(Pattern.quote(INTERNAL_COOKIE_SERIALIZATION_SEPARATOR));
        if (cookieTokens != null && cookieTokens.length == 3) {
            int expires = Integer.parseInt(cookieTokens[2]);
            return new TargetCookie(cookieTokens[0], cookieTokens[1], expires);
        }
        return null;
    }

    public static Optional<TargetCookie> createTargetCookie(String sessionId, String deviceId) {
        int maxAge;
        int nowInSeconds = CookieUtils.getNowInSeconds();
        StringBuilder targetCookieValue = new StringBuilder();
        int expires = 0;
        expires = CookieUtils.createSessionId(sessionId, nowInSeconds, targetCookieValue, expires);
        expires = CookieUtils.createDeviceId(deviceId, nowInSeconds, targetCookieValue, expires);
        TargetCookie targetCookie = null;
        String cookieValue = targetCookieValue.toString();
        int n = maxAge = expires == 0 ? 0 : expires - nowInSeconds;
        if (StringUtils.isNotEmpty(cookieValue)) {
            targetCookie = new TargetCookie("mbox", cookieValue, maxAge);
        }
        return Optional.ofNullable(targetCookie);
    }

    private static int getNowInSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private static int createDeviceId(String deviceId, int nowInSeconds, StringBuilder targetCookieValue, int expires) {
        if (StringUtils.isEmpty(deviceId)) {
            return expires;
        }
        int deviceIdExpires = nowInSeconds + 63244800;
        expires = Math.max(expires, deviceIdExpires);
        CookieUtils.appendCookieValue(deviceId, targetCookieValue, deviceIdExpires, DEVICE_ID_COOKIE_NAME);
        return expires;
    }

    private static int createSessionId(String sessionId, int nowInSeconds, StringBuilder targetCookieValue, int expires) {
        int sessionIdExpires;
        if (StringUtils.isEmpty(sessionId)) {
            return expires;
        }
        expires = sessionIdExpires = nowInSeconds + 1860;
        CookieUtils.appendCookieValue(sessionId, targetCookieValue, sessionIdExpires, SESSION_ID_COOKIE_NAME);
        return expires;
    }

    private static void appendCookieValue(String id, StringBuilder targetCookieValue, int expires, String cookieName) {
        targetCookieValue.append(cookieName).append(INTERNAL_COOKIE_SERIALIZATION_SEPARATOR).append(id).append(INTERNAL_COOKIE_SERIALIZATION_SEPARATOR).append(expires).append(COOKIE_VALUE_SEPARATOR);
    }

    public static Optional<TargetCookie> createClusterCookie(String tntId) {
        if (tntId == null) {
            return Optional.empty();
        }
        TargetCookie targetCookie = null;
        String locationHint = CookieUtils.locationHintFromTntId(tntId);
        if (locationHint != null) {
            targetCookie = new TargetCookie("mboxEdgeCluster", locationHint, 1860);
        }
        return Optional.ofNullable(targetCookie);
    }

    public static String locationHintFromTntId(String tntId) {
        String[] nodeDetails;
        String[] parts = tntId.split("\\.");
        if (parts.length == 2 && (nodeDetails = parts[1].split("_")).length == 2) {
            return nodeDetails[0];
        }
        return null;
    }

    public static String locationHintToNodeDetails(String locationHint) {
        return String.format("%s_0", locationHint);
    }

    public static Set<String> getTargetCookieNames() {
        if (TARGET_COOKIE_NAMES != null) {
            return TARGET_COOKIE_NAMES;
        }
        TARGET_COOKIE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("mbox", "mboxEdgeCluster", VisitorProvider.getInstance().getVisitorCookieName())));
        return TARGET_COOKIE_NAMES;
    }
}

