/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.utils;

import com.adobe.target.edge.client.utils.HashingUtils;

public class AllocationUtils {
    private static final int TOTAL_BUCKETS = 10000;
    private static final int MAX_PERCENTAGE = 100;

    public static String getDeviceId(String clientId, String activityId, String visitorId, String salt) {
        return clientId + "." + activityId + "." + visitorId + "." + salt;
    }

    public static double calculateAllocation(String clientId, String activityId, String visitorId, String salt) {
        return AllocationUtils.calculateAllocation(AllocationUtils.getDeviceId(clientId, activityId, visitorId, salt));
    }

    public static double calculateAllocation(String deviceId) {
        int hashValue = HashingUtils.hashUnencodedChars(deviceId);
        int hashFixedBucket = Math.abs(hashValue) % 10000;
        float allocationValue = (float)hashFixedBucket / 10000.0f * 100.0f;
        return (double)Math.round(allocationValue * 100.0f) / 100.0;
    }
}

