/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.service;

import com.adobe.experiencecloud.ecid.visitor.Visitor;
import com.adobe.target.edge.client.exception.TargetClientException;
import com.adobe.target.edge.client.exception.TargetRequestException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class VisitorProvider {
    private static VisitorProvider INSTANCE = null;
    private final String VISITOR_COOKIE_PREFIX = "AMCV_";
    private String visitorCookieName;
    private String orgId;

    private VisitorProvider(String orgId) throws UnsupportedEncodingException {
        this.orgId = orgId;
        this.visitorCookieName = "AMCV_" + URLEncoder.encode(orgId, "UTF-8");
    }

    public Visitor createVisitor(String visitorCookie) {
        return new Visitor(this.orgId, visitorCookie);
    }

    public String getVisitorCookieName() {
        return this.visitorCookieName;
    }

    public static VisitorProvider getInstance() {
        if (INSTANCE == null) {
            throw new TargetRequestException("VisitorProvider instance is not initialized");
        }
        return INSTANCE;
    }

    public static VisitorProvider init(String orgId) {
        try {
            INSTANCE = new VisitorProvider(orgId);
        }
        catch (UnsupportedEncodingException e) {
            throw new TargetClientException("Error occurred while initializing VisitorProvider", e);
        }
        return INSTANCE;
    }
}

