/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.service;

import com.adobe.target.delivery.v1.model.DecisioningMethod;
import com.adobe.target.delivery.v1.model.ExecuteRequest;
import com.adobe.target.delivery.v1.model.ExecutionMode;
import com.adobe.target.delivery.v1.model.PrefetchRequest;
import com.adobe.target.delivery.v1.model.Telemetry;
import com.adobe.target.delivery.v1.model.TelemetryEntry;
import com.adobe.target.delivery.v1.model.TelemetryFeatures;
import com.adobe.target.delivery.v1.model.TelemetryRequest;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.TargetDeliveryResponse;
import com.adobe.target.edge.client.utils.MathUtils;
import com.adobe.target.edge.client.utils.StringUtils;
import com.adobe.target.edge.client.utils.TimingTool;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TelemetryService {
    private final ClientConfig clientConfig;
    private final ConcurrentLinkedQueue<TelemetryEntry> storedTelemetries = new ConcurrentLinkedQueue();
    private static final int DECIMAL_PLACES = 2;

    public TelemetryService(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void addTelemetry(TargetDeliveryRequest deliveryRequest, TimingTool timer, TargetDeliveryResponse targetDeliveryResponse) {
        TelemetryEntry telemetryEntry = this.createTelemetryEntry(deliveryRequest, targetDeliveryResponse, timer.timeEnd("timing_execute_request"));
        if (telemetryEntry == null) {
            return;
        }
        this.storedTelemetries.add(telemetryEntry);
    }

    public void addTelemetry(Double artifactDownloadTime) {
        TelemetryEntry telemetryEntry = new TelemetryEntry();
        telemetryEntry.setExecution(artifactDownloadTime);
        telemetryEntry.setRequestId("ArtifactDownload");
        telemetryEntry.setTimestamp(System.currentTimeMillis());
        this.storedTelemetries.add(telemetryEntry);
    }

    public void addTelemetry(TargetDeliveryRequest deliveryRequest, TimingTool timer, TargetDeliveryResponse targetDeliveryResponse, double parsingTime, long responseSize) {
        TelemetryEntry telemetryEntry = this.createTelemetryEntry(deliveryRequest, targetDeliveryResponse, timer.timeEnd("timing_execute_request"));
        if (telemetryEntry == null) {
            return;
        }
        telemetryEntry.setParsing(parsingTime);
        TelemetryRequest telemetryRequest = new TelemetryRequest();
        telemetryRequest.setResponseSize(responseSize);
        telemetryEntry.setRequest(telemetryRequest);
        this.storedTelemetries.add(telemetryEntry);
    }

    public Telemetry getTelemetry() {
        TelemetryEntry telemetryEntry;
        ArrayList<TelemetryEntry> telemetryEntryList = new ArrayList<TelemetryEntry>();
        while ((telemetryEntry = this.storedTelemetries.poll()) != null) {
            telemetryEntryList.add(telemetryEntry);
        }
        return new Telemetry().entries(telemetryEntryList);
    }

    private TelemetryEntry createTelemetryEntry(TargetDeliveryRequest targetDeliveryRequest, TargetDeliveryResponse targetDeliveryResponse, double executionTime) {
        if (!this.clientConfig.isTelemetryEnabled() || targetDeliveryResponse.getResponse() == null) {
            return null;
        }
        TelemetryFeatures telemetryFeatures = this.buildTelemetryFeatures(targetDeliveryRequest);
        ExecutionMode executionMode = this.getMode(targetDeliveryResponse);
        return new TelemetryEntry().requestId(targetDeliveryResponse.getResponse().getRequestId()).telemetryServerToken(targetDeliveryResponse.getResponse().getTelemetryServerToken()).mode(executionMode).features(telemetryFeatures).execution(MathUtils.roundDouble(executionTime, 2)).timestamp(System.currentTimeMillis());
    }

    private com.adobe.target.edge.client.model.DecisioningMethod getDecisioningMethod(TargetDeliveryRequest request) {
        com.adobe.target.edge.client.model.DecisioningMethod requestDecisioning = request.getDecisioningMethod();
        if (requestDecisioning != null) {
            return requestDecisioning;
        }
        com.adobe.target.edge.client.model.DecisioningMethod configDecisioning = this.clientConfig.getDefaultDecisioningMethod();
        if (configDecisioning != null) {
            return configDecisioning;
        }
        return com.adobe.target.edge.client.model.DecisioningMethod.SERVER_SIDE;
    }

    private int executeMboxCount(TargetDeliveryRequest request) {
        int executeMboxCount = 0;
        ExecuteRequest executeRequest = request.getDeliveryRequest().getExecute();
        if (executeRequest != null) {
            executeMboxCount = executeRequest.getMboxes().size();
        }
        return executeMboxCount;
    }

    private Boolean isExecutePageLoad(TargetDeliveryRequest request) {
        boolean isExecutePageLoad = false;
        ExecuteRequest executeRequest = request.getDeliveryRequest().getExecute();
        if (executeRequest != null) {
            isExecutePageLoad = executeRequest.getPageLoad() != null;
        }
        return isExecutePageLoad;
    }

    private Integer prefetchMboxCount(TargetDeliveryRequest request) {
        int prefetchMboxCount = 0;
        PrefetchRequest prefetchRequest = request.getDeliveryRequest().getPrefetch();
        if (prefetchRequest != null) {
            prefetchMboxCount = prefetchRequest.getMboxes().size();
        }
        return prefetchMboxCount;
    }

    private Boolean isPrefetchPageLoad(TargetDeliveryRequest request) {
        boolean prefetchPageLoad = false;
        PrefetchRequest prefetchRequest = request.getDeliveryRequest().getPrefetch();
        if (prefetchRequest != null) {
            prefetchPageLoad = prefetchRequest.getPageLoad() != null;
        }
        return prefetchPageLoad;
    }

    private Integer prefetchViewCount(TargetDeliveryRequest request) {
        int prefetchViewCount = 0;
        if (request.getDeliveryRequest().getPrefetch() != null) {
            prefetchViewCount = request.getDeliveryRequest().getPrefetch().getViews().size();
        }
        return prefetchViewCount;
    }

    private ExecutionMode getMode(TargetDeliveryResponse targetDeliveryResponse) {
        return StringUtils.isNotEmpty(targetDeliveryResponse.getResponse().getEdgeHost()) ? ExecutionMode.EDGE : ExecutionMode.LOCAL;
    }

    private TelemetryFeatures buildTelemetryFeatures(TargetDeliveryRequest targetDeliveryRequest) {
        DecisioningMethod decisioningMethod = DecisioningMethod.valueOf(this.getDecisioningMethod(targetDeliveryRequest).name());
        TelemetryFeatures telemetryFeatures = new TelemetryFeatures();
        telemetryFeatures.setDecisioningMethod(decisioningMethod);
        int countOfExecutedMbox = this.executeMboxCount(targetDeliveryRequest);
        int countOfPrefetchedMbox = this.prefetchMboxCount(targetDeliveryRequest);
        int countOfPrefetchedView = this.prefetchViewCount(targetDeliveryRequest);
        boolean isItExecutePageLoad = this.isExecutePageLoad(targetDeliveryRequest);
        boolean isItPrefetchedPageLoad = this.isPrefetchPageLoad(targetDeliveryRequest);
        if (countOfExecutedMbox != 0) {
            telemetryFeatures.setExecuteMboxCount(countOfExecutedMbox);
        }
        if (countOfPrefetchedMbox != 0) {
            telemetryFeatures.setPrefetchMboxCount(countOfPrefetchedMbox);
        }
        if (countOfPrefetchedView != 0) {
            telemetryFeatures.setPrefetchViewCount(countOfPrefetchedView);
        }
        if (isItExecutePageLoad) {
            telemetryFeatures.setExecutePageLoad(true);
        }
        if (isItPrefetchedPageLoad) {
            telemetryFeatures.setPrefetchPageLoad(true);
        }
        return telemetryFeatures;
    }
}

