/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.service;

import com.adobe.target.delivery.v1.model.DeliveryResponse;
import com.adobe.target.delivery.v1.model.Geo;
import com.adobe.target.delivery.v1.model.Telemetry;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.http.DefaultTargetHttpClient;
import com.adobe.target.edge.client.http.ResponseStatus;
import com.adobe.target.edge.client.http.ResponseWrapper;
import com.adobe.target.edge.client.http.TargetHttpClient;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.TargetDeliveryResponse;
import com.adobe.target.edge.client.service.NotificationService;
import com.adobe.target.edge.client.service.TargetService;
import com.adobe.target.edge.client.service.TelemetryService;
import com.adobe.target.edge.client.utils.CookieUtils;
import com.adobe.target.edge.client.utils.StringUtils;
import com.adobe.target.edge.client.utils.TimingTool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTargetService
implements TargetService {
    public static final String SDK_USER_KEY = "X-EXC-SDK";
    public static final String SDK_USER_VALUE = "AdobeTargetJava";
    public static final String SDK_VERSION_KEY = "X-EXC-SDK-Version";
    public static final String SESSION_ID = "sessionId";
    public static final String ORGANIZATION_ID = "imsOrgId";
    private String sdkVersion;
    private final TargetHttpClient targetHttpClient;
    private final ClientConfig clientConfig;
    private String stickyLocationHint;
    private final TelemetryService telemetryService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultTargetHttpClient.class);

    public DefaultTargetService(ClientConfig clientConfig, TelemetryService telemetryService) {
        DefaultTargetHttpClient targetHttpClient = new DefaultTargetHttpClient(clientConfig);
        this.targetHttpClient = clientConfig.isLogRequests() ? TargetHttpClient.createLoggingHttpClient(targetHttpClient) : targetHttpClient;
        this.loadDefaultProperties();
        this.setDefaultHeaders();
        this.clientConfig = clientConfig;
        this.telemetryService = telemetryService;
    }

    private void loadDefaultProperties() {
        Properties defaultProps = new Properties();
        try {
            defaultProps.load(this.getClass().getResourceAsStream("/gradle.properties"));
        }
        catch (IOException e) {
            logger.warn("Unable to load default SDK properties");
        }
        this.sdkVersion = defaultProps.getProperty("version");
    }

    private void setDefaultHeaders() {
        this.targetHttpClient.addDefaultHeader(SDK_USER_KEY, SDK_USER_VALUE);
        if (this.sdkVersion != null) {
            this.targetHttpClient.addDefaultHeader(SDK_VERSION_KEY, this.sdkVersion);
        }
    }

    @Override
    public TargetDeliveryResponse executeRequest(TargetDeliveryRequest deliveryRequest) {
        TimingTool timer = new TimingTool();
        timer.timeStart("timing_execute_request");
        Telemetry telemetry = this.telemetryService.getTelemetry();
        if (!telemetry.getEntries().isEmpty()) {
            deliveryRequest.getDeliveryRequest().setTelemetry(telemetry);
        }
        this.cleanUpGeoContext(deliveryRequest);
        ResponseWrapper<DeliveryResponse> response = this.callDeliveryApi(deliveryRequest);
        TargetDeliveryResponse targetDeliveryResponse = this.getTargetDeliveryResponse(deliveryRequest, response.getHttpResponse());
        this.telemetryService.addTelemetry(deliveryRequest, timer, targetDeliveryResponse, response.getParsingTime(), response.getResponseSize());
        return targetDeliveryResponse;
    }

    @Override
    public CompletableFuture<TargetDeliveryResponse> executeRequestAsync(TargetDeliveryRequest deliveryRequest) {
        TimingTool timer = new TimingTool();
        timer.timeStart("timing_execute_request");
        Telemetry telemetry = this.telemetryService.getTelemetry();
        if (!telemetry.getEntries().isEmpty()) {
            deliveryRequest.getDeliveryRequest().setTelemetry(telemetry);
        }
        this.cleanUpGeoContext(deliveryRequest);
        CompletableFuture<ResponseWrapper<DeliveryResponse>> responseCompletableFuture = this.callDeliveryApiAsync(deliveryRequest);
        return responseCompletableFuture.thenApply(response -> {
            TargetDeliveryResponse targetDeliveryResponse = this.getTargetDeliveryResponse(deliveryRequest, response.getHttpResponse());
            this.telemetryService.addTelemetry(deliveryRequest, timer, targetDeliveryResponse, response.getParsingTime(), response.getResponseSize());
            return targetDeliveryResponse;
        });
    }

    @Override
    public ResponseStatus executeNotification(TargetDeliveryRequest deliveryRequest) {
        TimingTool timer = new TimingTool();
        timer.timeStart("timing_execute_request");
        NotificationService.setBeaconToFalse(deliveryRequest.getDeliveryRequest());
        Telemetry telemetry = this.telemetryService.getTelemetry();
        if (!telemetry.getEntries().isEmpty()) {
            deliveryRequest.getDeliveryRequest().setTelemetry(telemetry);
        }
        this.cleanUpGeoContext(deliveryRequest);
        ResponseWrapper<DeliveryResponse> response = this.callDeliveryApi(deliveryRequest);
        TargetDeliveryResponse targetDeliveryResponse = this.getTargetDeliveryResponse(deliveryRequest, response.getHttpResponse());
        this.telemetryService.addTelemetry(deliveryRequest, timer, targetDeliveryResponse, response.getParsingTime(), response.getResponseSize());
        return new ResponseStatus(response.getHttpResponse().getStatus(), response.getHttpResponse().getStatusText());
    }

    @Override
    public CompletableFuture<ResponseStatus> executeNotificationAsync(TargetDeliveryRequest deliveryRequest) {
        TimingTool timer = new TimingTool();
        timer.timeStart("timing_execute_request");
        NotificationService.setBeaconToFalse(deliveryRequest.getDeliveryRequest());
        Telemetry telemetry = this.telemetryService.getTelemetry();
        if (!telemetry.getEntries().isEmpty()) {
            deliveryRequest.getDeliveryRequest().setTelemetry(telemetry);
        }
        this.cleanUpGeoContext(deliveryRequest);
        CompletableFuture<ResponseWrapper<DeliveryResponse>> responseCompletableFuture = this.callDeliveryApiAsync(deliveryRequest);
        return responseCompletableFuture.thenApply(response -> {
            TargetDeliveryResponse targetDeliveryResponse = this.getTargetDeliveryResponse(deliveryRequest, response.getHttpResponse());
            this.telemetryService.addTelemetry(deliveryRequest, timer, targetDeliveryResponse, response.getParsingTime(), response.getResponseSize());
            return new ResponseStatus(response.getHttpResponse().getStatus(), response.getHttpResponse().getStatusText());
        });
    }

    private Map<String, Object> getQueryParams(TargetDeliveryRequest deliveryRequest) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(SESSION_ID, deliveryRequest.getSessionId());
        queryParams.put(ORGANIZATION_ID, this.clientConfig.getOrganizationId());
        return queryParams;
    }

    private TargetDeliveryResponse getTargetDeliveryResponse(TargetDeliveryRequest deliveryRequest, HttpResponse<DeliveryResponse> response) {
        DeliveryResponse deliveryResponse = this.retrieveDeliveryResponse(response);
        this.updateStickyLocationHint(deliveryResponse);
        return new TargetDeliveryResponse(deliveryRequest, deliveryResponse, response.getStatus(), response.getStatusText());
    }

    private DeliveryResponse retrieveDeliveryResponse(HttpResponse<DeliveryResponse> response) {
        DeliveryResponse deliveryResponse = (DeliveryResponse)response.getBody();
        if (deliveryResponse == null) {
            Optional parsingError = response.getParsingError();
            throw new RuntimeException("Error parsing delivery response: {}. " + (parsingError.isPresent() ? ((UnirestParsingException)parsingError.get()).getOriginalBody() : ""));
        }
        return deliveryResponse;
    }

    private void updateStickyLocationHint(DeliveryResponse deliveryResponse) {
        if (StringUtils.isNotEmpty(this.stickyLocationHint)) {
            return;
        }
        if (deliveryResponse != null && deliveryResponse.getStatus() == 200 && deliveryResponse.getId() != null && deliveryResponse.getId().getTntId() != null) {
            String tntId = deliveryResponse.getId().getTntId();
            this.stickyLocationHint = CookieUtils.locationHintFromTntId(tntId);
        }
    }

    @Override
    public void close() throws Exception {
        this.targetHttpClient.close();
    }

    private String getBestLocationHint(TargetDeliveryRequest deliveryRequest) {
        if (deliveryRequest.getLocationHint() != null) {
            return deliveryRequest.getLocationHint();
        }
        return this.stickyLocationHint;
    }

    private ResponseWrapper<DeliveryResponse> callDeliveryApi(TargetDeliveryRequest deliveryRequest) {
        String url = this.clientConfig.getUrl(this.getBestLocationHint(deliveryRequest));
        return this.targetHttpClient.execute(this.getQueryParams(deliveryRequest), url, deliveryRequest.getDeliveryRequest(), DeliveryResponse.class);
    }

    private CompletableFuture<ResponseWrapper<DeliveryResponse>> callDeliveryApiAsync(TargetDeliveryRequest deliveryRequest) {
        String url = this.clientConfig.getUrl(this.getBestLocationHint(deliveryRequest));
        return this.targetHttpClient.executeAsync(this.getQueryParams(deliveryRequest), url, deliveryRequest.getDeliveryRequest(), DeliveryResponse.class);
    }

    private void cleanUpGeoContext(TargetDeliveryRequest deliveryRequest) {
        Geo geo = null;
        if (deliveryRequest.getDeliveryRequest() != null && deliveryRequest.getDeliveryRequest().getContext() != null) {
            geo = deliveryRequest.getDeliveryRequest().getContext().getGeo();
        }
        if (geo != null) {
            if (geo.getStateCode() != null && geo.getStateCode().isEmpty()) {
                geo.setStateCode(null);
            }
            if (geo.getCity() != null && geo.getCity().isEmpty()) {
                geo.setCity(null);
            }
            if (geo.getCountryCode() != null && geo.getCountryCode().isEmpty()) {
                geo.setCountryCode(null);
            }
        }
    }
}

