/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice.collator;

import com.adobe.target.delivery.v1.model.ClientHints;
import com.adobe.target.delivery.v1.model.Context;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.ondevice.collator.ParamsCollator;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserParamsCollator
implements ParamsCollator {
    private static final Logger logger = LoggerFactory.getLogger(UserParamsCollator.class);
    protected static final String USER_BROWSER_TYPE = "browserType";
    protected static final String USER_BROWSER_VERSION = "browserVersion";
    protected static final String USER_PLATFORM = "platform";
    protected static final String UNKNOWN = "unknown";
    private static final Map<String, Predicate<String>> BROWSER_TYPE_MATCHER = Collections.unmodifiableMap(new LinkedHashMap<String, Predicate<String>>(){
        {
            this.put("chrome", browser -> (browser.contains("Chrome") || browser.contains("CriOS")) && !browser.contains("OPR") && !browser.contains("Edge/"));
            this.put("firefox", browser -> browser.contains("Firefox"));
            this.put("ie", browser -> browser.contains("MSIE") || browser.contains("Trident"));
            this.put("opera", browser -> browser.contains("Opera") || browser.contains("OPR"));
            this.put("ipad", browser -> browser.contains("iPad"));
            this.put("iphone", browser -> browser.contains("iPhone"));
            this.put("safari", browser -> browser.contains("Safari") && !browser.contains("Chrome") && !browser.contains("OPR") && !browser.contains("CriOS"));
            this.put("edge", browser -> browser.contains("Edge"));
        }
    });
    private static final Map<String, String> PLATFORMS_MAPPING = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
        {
            this.put("Windows", "windows");
            this.put("Macintosh", "mac");
            this.put("Mac OS", "mac");
            this.put("macOS", "mac");
            this.put("Linux", "linux");
        }
    });
    private static final Map<String, List<Pattern>> BROWSER_VERSION_PATTERNS = Collections.unmodifiableMap(new HashMap<String, List<Pattern>>(){
        {
            this.put("chrome", UserParamsCollator.compilePatterns(new String[]{"chrome/(\\d+)", "crios/(\\d+)", "Chrome\";v=\"(\\d+)"}));
            this.put("firefox", UserParamsCollator.compilePatterns(new String[]{"firefox/(\\d+)", "Firefox\";v=\"(\\d+)"}));
            this.put("ie", UserParamsCollator.compilePatterns(new String[]{"msie\\s(\\d+)", "rv:(\\d+)"}));
            this.put("opera", UserParamsCollator.compilePatterns(new String[]{"version/(\\d+)", "opera/(\\d+)", "opera\\s*(\\d+)", "OPR/(\\d+)"}));
            this.put("ipad", UserParamsCollator.compilePatterns(new String[]{"version/(\\d+)"}));
            this.put("iphone", UserParamsCollator.compilePatterns(new String[]{"version/(\\d+)"}));
            this.put("safari", UserParamsCollator.compilePatterns(new String[]{"version/(\\d+)", "Safari\";v=\"(\\d+)"}));
            this.put("edge", UserParamsCollator.compilePatterns(new String[]{"edge/(\\d+)", "Edge\";v=\"(\\d+)"}));
        }
    });
    private static final int BROWSER_VERSION_PATTERN_GROUP_INDEX = 1;
    private static final String COMPATIBILITY_TOKEN_START = "(compatible;";
    private static final String COMPATIBILITY_TOKEN_END = ")";
    private static final int COMPATIBILITY_TOKEN_START_LENGTH = "(compatible;".length();
    private static final int COMPATIBILITY_TOKEN_END_LENGTH = ")".length();

    @Override
    public Map<String, Object> collateParams(TargetDeliveryRequest deliveryRequest, RequestDetails requestDetails) {
        HashMap<String, Object> user = new HashMap<String, Object>();
        String userAgent = this.extractUserAgent(deliveryRequest);
        ClientHints clientHints = this.extractClientHints(deliveryRequest);
        String browserInfo = this.getBrowserInfo(userAgent, clientHints);
        String browserType = this.parseBrowserType(browserInfo);
        user.put(USER_BROWSER_TYPE, browserType);
        user.put(USER_PLATFORM, UserParamsCollator.parsePlatform(userAgent, clientHints));
        user.put(USER_BROWSER_VERSION, this.parseBrowserVersion(browserInfo, browserType));
        return user;
    }

    private String parseBrowserType(String browserInfo) {
        if (StringUtils.isEmpty(browserInfo)) {
            return UNKNOWN;
        }
        return BROWSER_TYPE_MATCHER.entrySet().stream().filter(browserType -> ((Predicate)browserType.getValue()).test(browserInfo)).findFirst().map(Map.Entry::getKey).orElse(UNKNOWN);
    }

    private String getBrowserInfo(String userAgent, ClientHints clientHints) {
        String browserInfo = userAgent;
        if (clientHints != null) {
            if (StringUtils.isNotEmpty(clientHints.getBrowserUAWithFullVersion())) {
                browserInfo = clientHints.getBrowserUAWithFullVersion();
            } else if (StringUtils.isNotEmpty(clientHints.getBrowserUAWithMajorVersion())) {
                browserInfo = clientHints.getBrowserUAWithMajorVersion();
            }
        }
        return browserInfo;
    }

    private static String parsePlatform(String userAgent, ClientHints clientHints) {
        String platform;
        if (clientHints != null && StringUtils.isNotEmpty(clientHints.getPlatform())) {
            platform = clientHints.getPlatform();
        } else if (StringUtils.isNotEmpty(userAgent)) {
            platform = userAgent;
        } else {
            return UNKNOWN;
        }
        return PLATFORMS_MAPPING.entrySet().stream().filter(it -> platform.contains((CharSequence)it.getKey())).findFirst().map(Map.Entry::getValue).orElse(UNKNOWN);
    }

    private String parseBrowserVersion(String browserInfo, String userBrowserType) {
        List<Pattern> patterns = BROWSER_VERSION_PATTERNS.get(userBrowserType);
        if (patterns == null || browserInfo == null) {
            return UNKNOWN;
        }
        return this.getMainAndCompatibilitySections(browserInfo).stream().map(section -> this.findBrowserVersion((String)section, patterns)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(UNKNOWN);
    }

    private String extractUserAgent(TargetDeliveryRequest deliveryRequest) {
        Context context = deliveryRequest.getDeliveryRequest().getContext();
        if (context == null) {
            return null;
        }
        String userAgent = context.getUserAgent();
        if (StringUtils.isEmpty(userAgent)) {
            return null;
        }
        return userAgent;
    }

    private ClientHints extractClientHints(TargetDeliveryRequest deliveryRequest) {
        Context context = deliveryRequest.getDeliveryRequest().getContext();
        return context != null ? context.getClientHints() : null;
    }

    private static List<Pattern> compilePatterns(String ... patterns) {
        return Arrays.stream(patterns).map(definition -> Pattern.compile(definition, 2)).collect(Collectors.toList());
    }

    private Optional<String> findBrowserVersion(String userAgent, List<Pattern> patterns) {
        if (StringUtils.isEmpty(userAgent)) {
            return Optional.empty();
        }
        return patterns.stream().map(pattern -> {
            Matcher matcher = pattern.matcher(userAgent);
            return matcher.find() ? matcher.group(1) : null;
        }).filter(Objects::nonNull).findFirst();
    }

    private List<String> getMainAndCompatibilitySections(String userAgent) {
        int compatibilitySectionStart = userAgent.indexOf(COMPATIBILITY_TOKEN_START);
        if (compatibilitySectionStart == -1) {
            return Collections.singletonList(userAgent);
        }
        int compatibilitySectionEnd = userAgent.indexOf(COMPATIBILITY_TOKEN_END, compatibilitySectionStart);
        if (compatibilitySectionEnd == -1) {
            return Collections.singletonList(userAgent);
        }
        return this.parseCompatibilitySections(userAgent);
    }

    private List<String> parseCompatibilitySections(String userAgent) {
        ParserState state = new ParserState(userAgent);
        while (state.hasUnprocessedChars()) {
            if (state.atToken(COMPATIBILITY_TOKEN_START)) {
                state.addToStore();
                state.nextLevel();
                state.advance(COMPATIBILITY_TOKEN_START_LENGTH);
                continue;
            }
            if (state.atToken(COMPATIBILITY_TOKEN_END)) {
                state.addToStore();
                state.prevLevel();
                state.advance(COMPATIBILITY_TOKEN_END_LENGTH);
                continue;
            }
            state.next();
        }
        state.addToStore();
        return state.build();
    }

    private static class ParserState {
        private static final int MAX_LEVEL = 5;
        private static final int MIN_LEVEL = 0;
        private final String data;
        private final int dataLength;
        private final List<StringBuilder> levelStore = new ArrayList<StringBuilder>();
        private int levelIndex = 0;
        private int currentCharIndex = 0;
        private int regionStartIndex = 0;

        private ParserState(String data) {
            this.data = data;
            this.dataLength = data.length();
        }

        void advance(int count) {
            this.currentCharIndex = this.regionStartIndex = this.currentCharIndex + count;
        }

        void next() {
            ++this.currentCharIndex;
        }

        boolean hasUnprocessedChars() {
            return this.currentCharIndex < this.dataLength;
        }

        boolean atToken(String token) {
            return this.data.startsWith(token, this.currentCharIndex);
        }

        void nextLevel() {
            ++this.levelIndex;
            if (this.levelIndex > 5) {
                this.levelIndex = 5;
            }
        }

        void prevLevel() {
            --this.levelIndex;
            if (this.levelIndex < 0) {
                this.levelIndex = 0;
            }
        }

        void addToStore() {
            this.ensureStoreHasSpace();
            String currentSubstring = this.data.substring(this.regionStartIndex, this.currentCharIndex);
            this.levelStore.get(this.levelIndex).append(currentSubstring);
        }

        private void ensureStoreHasSpace() {
            while (this.levelStore.size() <= this.levelIndex) {
                this.levelStore.add(new StringBuilder());
            }
        }

        List<String> build() {
            return this.levelStore.stream().map(StringBuilder::toString).collect(Collectors.toList());
        }
    }
}

