/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice.collator;

import com.adobe.target.delivery.v1.model.Address;
import com.adobe.target.delivery.v1.model.Context;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.ondevice.collator.ParamsCollator;
import com.adobe.target.edge.client.utils.StringUtils;
import com.google.common.net.InternetDomainName;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageParamsCollator
implements ParamsCollator {
    private static final Logger logger = LoggerFactory.getLogger(PageParamsCollator.class);
    protected static final String PAGE_URL = "url";
    protected static final String PAGE_URL_LOWER = "url_lc";
    protected static final String PAGE_DOMAIN = "domain";
    protected static final String PAGE_DOMAIN_LOWER = "domain_lc";
    protected static final String PAGE_SUBDOMAIN = "subdomain";
    protected static final String PAGE_SUBDOMAIN_LOWER = "subdomain_lc";
    protected static final String PAGE_TOP_LEVEL_DOMAIN = "topLevelDomain";
    protected static final String PAGE_TOP_LEVEL_DOMAIN_LOWER = "topLevelDomain_lc";
    protected static final String PAGE_PATH = "path";
    protected static final String PAGE_PATH_LOWER = "path_lc";
    protected static final String PAGE_QUERY = "query";
    protected static final String PAGE_QUERY_LOWER = "query_lc";
    protected static final String PAGE_FRAGMENT = "fragment";
    protected static final String PAGE_FRAGMENT_LOWER = "fragment_lc";
    private boolean referring = false;

    public PageParamsCollator() {
    }

    public PageParamsCollator(boolean referring) {
        this.referring = referring;
    }

    @Override
    public Map<String, Object> collateParams(TargetDeliveryRequest deliveryRequest, RequestDetails requestDetails) {
        Address address;
        HashMap<String, Object> page = new HashMap<String, Object>();
        Context context = deliveryRequest.getDeliveryRequest().getContext();
        if (context == null) {
            return page;
        }
        Address address2 = address = requestDetails.getAddress() != null ? requestDetails.getAddress() : context.getAddress();
        if (address == null) {
            return page;
        }
        try {
            String urlToUse;
            String string = urlToUse = this.referring ? address.getReferringUrl() : address.getUrl();
            if (StringUtils.isEmpty(urlToUse)) {
                return page;
            }
            URL url = new URL(urlToUse);
            page.put(PAGE_URL, url.toString());
            page.put(PAGE_URL_LOWER, url.toString().toLowerCase());
            String host = url.getHost();
            page.put(PAGE_DOMAIN, this.strOrBlank(host));
            page.put(PAGE_DOMAIN_LOWER, this.strLowerOrBlank(host));
            String subdomain = this.extractSubDomain(host);
            page.put(PAGE_SUBDOMAIN, this.strOrBlank(subdomain));
            page.put(PAGE_SUBDOMAIN_LOWER, this.strLowerOrBlank(subdomain));
            String topLevelDomain = this.extractTopLevel(host);
            page.put(PAGE_TOP_LEVEL_DOMAIN, this.strOrBlank(topLevelDomain));
            page.put(PAGE_TOP_LEVEL_DOMAIN_LOWER, this.strLowerOrBlank(topLevelDomain));
            String path = url.getPath();
            page.put(PAGE_PATH, this.strOrBlank(path));
            page.put(PAGE_PATH_LOWER, this.strLowerOrBlank(path));
            String query = url.getQuery();
            page.put(PAGE_QUERY, this.strOrBlank(query));
            page.put(PAGE_QUERY_LOWER, this.strLowerOrBlank(query));
            String fragment = url.getRef();
            page.put(PAGE_FRAGMENT, this.strOrBlank(fragment));
            page.put(PAGE_FRAGMENT_LOWER, this.strLowerOrBlank(fragment));
        }
        catch (MalformedURLException ex) {
            logger.warn("URL in context address malformed, skipping", (Throwable)ex);
        }
        return page;
    }

    private String extractTopLevel(String host) {
        if (host == null) {
            return "";
        }
        String lowerCaseHost = host.toLowerCase();
        InternetDomainName publicSuffix = InternetDomainName.from((String)host).publicSuffix();
        if (publicSuffix == null) {
            return "";
        }
        String lowerCaseResult = publicSuffix.toString();
        if (lowerCaseHost.equals(host)) {
            return lowerCaseResult;
        }
        return lowerCaseResult.toUpperCase();
    }

    private String extractSubDomain(String host) {
        InternetDomainName domain;
        if (host == null) {
            return "";
        }
        String lowerCaseHost = host.toLowerCase();
        if (lowerCaseHost.startsWith("www.")) {
            lowerCaseHost = lowerCaseHost.substring(4);
            host = host.substring(4);
        }
        if (!(domain = InternetDomainName.from((String)lowerCaseHost)).hasPublicSuffix()) {
            return "";
        }
        String topPrivateDomain = domain.topPrivateDomain().toString();
        int endIndex = lowerCaseHost.indexOf(topPrivateDomain);
        if (endIndex == 0) {
            return "";
        }
        return host.substring(0, endIndex - 1);
    }

    private String strOrBlank(String str) {
        return str != null ? str : "";
    }

    private String strLowerOrBlank(String str) {
        return str != null ? str.toLowerCase() : "";
    }
}

