/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice.collator;

import com.adobe.target.delivery.v1.model.Context;
import com.adobe.target.delivery.v1.model.Geo;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.ondevice.collator.ParamsCollator;
import com.adobe.target.edge.client.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class GeoParamsCollator
implements ParamsCollator {
    public static final Map<String, Object> DEFAULT_GEO_PARAMS = new HashMap<String, Object>(){
        {
            this.put(GeoParamsCollator.GEO_LATITUDE, null);
            this.put(GeoParamsCollator.GEO_LONGITUDE, null);
            this.put(GeoParamsCollator.GEO_CITY, "");
            this.put(GeoParamsCollator.GEO_REGION, "");
            this.put(GeoParamsCollator.GEO_COUNTRY, "");
        }
    };
    protected static final String GEO_LATITUDE = "latitude";
    protected static final String GEO_LONGITUDE = "longitude";
    protected static final String GEO_CITY = "city";
    protected static final String GEO_REGION = "region";
    protected static final String GEO_COUNTRY = "country";

    @Override
    public Map<String, Object> collateParams(TargetDeliveryRequest deliveryRequest, RequestDetails requestDetails) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Context context = deliveryRequest.getDeliveryRequest().getContext();
        if (context == null || context.getGeo() == null) {
            params.putAll(DEFAULT_GEO_PARAMS);
            return params;
        }
        Geo geo = context.getGeo();
        params.put(GEO_LATITUDE, geo.getLatitude());
        params.put(GEO_LONGITUDE, geo.getLongitude());
        params.put(GEO_CITY, StringUtils.isEmpty(geo.getCity()) ? "" : geo.getCity().toUpperCase().replace(" ", ""));
        params.put(GEO_REGION, StringUtils.isEmpty(geo.getStateCode()) ? "" : geo.getStateCode().toUpperCase());
        params.put(GEO_COUNTRY, StringUtils.isEmpty(geo.getCountryCode()) ? "" : geo.getCountryCode().toUpperCase());
        return params;
    }
}

