/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice.collator;

import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.ondevice.collator.ParamsCollator;
import java.util.HashMap;
import java.util.Map;

public class CustomParamsCollator
implements ParamsCollator {
    protected static final String LOWER_CASE_POSTFIX = "_lc";

    @Override
    public Map<String, Object> collateParams(TargetDeliveryRequest deliveryRequest, RequestDetails requestDetails) {
        Map<String, Object> custom = new HashMap<String, Object>();
        this.addAllParameters(custom, requestDetails);
        custom = this.createNestedParametersFromDots(custom);
        return custom;
    }

    private void addAllParameters(Map<String, Object> custom, RequestDetails details) {
        Map<String, String> params;
        if (details != null && (params = details.getParameters()) != null) {
            custom.putAll(params);
            params.forEach((key, value) -> custom.put(key + LOWER_CASE_POSTFIX, value.toLowerCase()));
        }
    }

    private Map<String, Object> createNestedParametersFromDots(Map<String, Object> custom) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        custom.forEach((key, value) -> {
            if (key.contains(".") && !key.contains("..") && key.charAt(0) != '.' && key.charAt(key.length() - 1) != '.') {
                this.addNestedKeyToParameters((Map<String, Object>)result, (String)key, value);
                return;
            }
            result.put((String)key, value);
        });
        return result;
    }

    private void addNestedKeyToParameters(Map<String, Object> custom, String key, Object value) {
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            custom.putIfAbsent((String)keys[i], new HashMap());
            custom = (Map)custom.get(keys[i]);
        }
        custom.put((String)keys[keys.length - 1], (Object)value);
    }
}

