/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice.client.geo;

import com.adobe.target.delivery.v1.model.Geo;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.ClientProxyConfig;
import com.adobe.target.edge.client.http.LoggingMetricConsumer;
import com.adobe.target.edge.client.http.TargetMetrics;
import com.adobe.target.edge.client.ondevice.client.geo.GeoClient;
import kong.unirest.GetRequest;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.UniMetric;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;

public class DefaultGeoClient
implements GeoClient {
    public static final String GEO_PATH = "/v1/geo";
    public static final String GEO_IP_HEADER = "x-forwarded-for";
    public static final String GEO_HEADER_CITY = "x-geo-city";
    public static final String GEO_HEADER_REGION = "x-geo-region-code";
    public static final String GEO_HEADER_COUNTRY = "x-geo-country-code";
    public static final String GEO_HEADER_LATITUDE = "x-geo-latitude";
    public static final String GEO_HEADER_LONGITUDE = "x-geo-longitude";
    private UnirestInstance unirestInstance = Unirest.spawnInstance();
    private String geoUrl;

    @Override
    public void start(ClientConfig clientConfig) {
        this.geoUrl = "https://" + clientConfig.getOnDeviceConfigHostname() + GEO_PATH;
        this.unirestInstance.config().socketTimeout(clientConfig.getSocketTimeout()).connectTimeout(clientConfig.getConnectTimeout()).concurrency(clientConfig.getMaxConnectionsTotal(), clientConfig.getMaxConnectionsPerHost()).automaticRetries(clientConfig.isEnabledRetries()).enableCookieManagement(false);
        if (clientConfig.isLogRequestStatus()) {
            this.unirestInstance.config().instrumentWith((UniMetric)new TargetMetrics(new LoggingMetricConsumer()));
        }
        if (clientConfig.isProxyEnabled()) {
            ClientProxyConfig proxyConfig = clientConfig.getProxyConfig();
            if (proxyConfig.isAuthProxy()) {
                this.unirestInstance.config().proxy(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            } else {
                this.unirestInstance.config().proxy(proxyConfig.getHost(), proxyConfig.getPort());
            }
        }
    }

    @Override
    public Geo lookupGeo(String ip) {
        HttpResponse response = this.geoRequest(this.geoUrl, GEO_IP_HEADER, ip).asEmpty();
        return this.headersToGeo(response.getHeaders());
    }

    @Override
    public void close() {
        this.unirestInstance.shutDown();
    }

    protected GetRequest geoRequest(String url, String headerName, String headerValue) {
        return (GetRequest)this.unirestInstance.get(url).header(headerName, headerValue);
    }

    protected Geo headersToGeo(Headers headers) {
        Geo geo = new Geo();
        geo.setCity(headers.getFirst(GEO_HEADER_CITY));
        geo.setStateCode(headers.getFirst(GEO_HEADER_REGION));
        geo.setCountryCode(headers.getFirst(GEO_HEADER_COUNTRY));
        geo.setLatitude(this.parseFloat(headers.getFirst(GEO_HEADER_LATITUDE)));
        geo.setLongitude(this.parseFloat(headers.getFirst(GEO_HEADER_LONGITUDE)));
        return geo;
    }

    private Float parseFloat(String floatStr) {
        if (floatStr == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(floatStr));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

