/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.delivery.v1.model.Address;
import com.adobe.target.delivery.v1.model.CustomerId;
import com.adobe.target.delivery.v1.model.Notification;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.delivery.v1.model.ViewRequest;
import com.adobe.target.delivery.v1.model.VisitorId;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRule;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRuleSet;
import com.adobe.target.edge.client.ondevice.RuleLoader;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class TraceHandler {
    private static final String MATCHED_IDS_KEY = "matchedSegmentIds";
    private static final String UNMATCHED_IDS_KEY = "unmatchedSegmentIds";
    private static final String MATCHED_RULES_KEY = "matchedRuleConditions";
    private static final String UNMATCHED_RULES_KEY = "unmatchedRuleConditions";
    public static final String ACTIVITY_ID = "activity.id";
    public static final String ACTIVITY_NAME = "activity.name";
    public static final String ACTIVITY_TYPE = "activity.type";
    public static final String EXPERIENCE_ID = "experience.id";
    public static final String AUDIENCE_IDS = "audience.ids";
    public static final String OFFER_ID = "offer.id";
    private final TimeZone utc = TimeZone.getTimeZone("UTC");
    private final ObjectMapper mapper;
    private final OnDeviceDecisioningRuleSet ruleSet;
    private final Map<String, Object> trace;
    private final Map<Number, Map<String, Object>> campaigns;
    private final Map<Number, Map<String, Object>> evaluatedTargets;

    public TraceHandler(ClientConfig clientConfig, RuleLoader ruleLoader, ObjectMapper mapper, OnDeviceDecisioningRuleSet ruleSet, TargetDeliveryRequest request) {
        this.mapper = mapper;
        this.ruleSet = ruleSet;
        this.trace = new HashMap<String, Object>();
        this.trace.put("clientCode", clientConfig.getClient());
        this.trace.put("artifact", this.artifactTrace(ruleLoader, ruleSet));
        this.trace.put("profile", this.profileTrace(request.getDeliveryRequest().getId()));
        this.campaigns = new HashMap<Number, Map<String, Object>>();
        this.evaluatedTargets = new HashMap<Number, Map<String, Object>>();
    }

    public void updateRequest(TargetDeliveryRequest request, RequestDetails details, boolean execute) {
        this.trace.put("request", this.requestTrace(request, details, execute));
    }

    public void addCampaign(OnDeviceDecisioningRule rule, Map<String, Object> context, boolean matched) {
        List rules;
        List ids;
        Map<String, Object> target;
        Map<String, Object> meta = rule.getMeta();
        Number activityId = (Number)meta.get(ACTIVITY_ID);
        if (activityId == null) {
            return;
        }
        if (matched && !this.campaigns.containsKey(activityId)) {
            Map<String, Object> campaign = this.campaignTrace(rule);
            campaign.put("branchId", meta.get(EXPERIENCE_ID));
            campaign.put("offers", meta.get(OFFER_ID));
            this.campaigns.put(activityId, campaign);
        }
        if ((target = this.evaluatedTargets.get(activityId)) == null) {
            target = this.campaignTargetTrace(rule, context);
            this.evaluatedTargets.put(activityId, target);
        }
        List audienceIds = (List)meta.get(AUDIENCE_IDS);
        if (matched) {
            ids = (List)target.get(MATCHED_IDS_KEY);
            rules = (List)target.get(MATCHED_RULES_KEY);
        } else {
            ids = (List)target.get(UNMATCHED_IDS_KEY);
            rules = (List)target.get(UNMATCHED_RULES_KEY);
        }
        ids.addAll(audienceIds);
        rules.add(rule.getCondition());
    }

    public void addNotification(OnDeviceDecisioningRule rule, Notification notification) {
        Map<String, Object> meta = rule.getMeta();
        Number activityId = (Number)meta.get(ACTIVITY_ID);
        if (activityId == null) {
            return;
        }
        Map<String, Object> campaign = this.campaigns.get(activityId);
        if (campaign == null) {
            return;
        }
        Map notificationMap = (Map)this.mapper.convertValue((Object)notification, Map.class);
        campaign.put("notifications", Collections.singletonList(notificationMap));
    }

    public Map<String, Object> getCurrentTrace() {
        HashMap<String, Object> currentTrace = new HashMap<String, Object>(this.trace);
        currentTrace.put("campaigns", this.campaigns.values());
        currentTrace.put("evaluatedCampaignTargets", this.evaluatedTargets.values());
        return currentTrace;
    }

    private Map<String, Object> artifactTrace(RuleLoader ruleLoader, OnDeviceDecisioningRuleSet ruleSet) {
        HashMap<String, Object> artifacts = new HashMap<String, Object>(ruleSet.getMeta());
        artifacts.put("artifactVersion", ruleSet.getVersion());
        artifacts.put("pollingInterval", ruleLoader.getPollingInterval());
        artifacts.put("artifactRetrievalCount", ruleLoader.getNumFetches());
        artifacts.put("artifactLocation", ruleLoader.getLocation());
        artifacts.put("pollingHalted", false);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        format.setTimeZone(this.utc);
        artifacts.put("artifactLastRetrieved", format.format(ruleLoader.getLastFetch()));
        return artifacts;
    }

    private Map<String, Object> profileTrace(VisitorId visitorId) {
        String tntId;
        HashMap<String, Object> profile = new HashMap<String, Object>();
        if (visitorId != null && (tntId = visitorId.getTntId()) != null) {
            List<CustomerId> customerIds;
            String thirdParty;
            HashMap<String, Object> visitorIdMap = new HashMap<String, Object>();
            int idx = tntId.lastIndexOf(".");
            if (idx >= 0 && idx < tntId.length() - 1) {
                visitorIdMap.put("tntId", tntId.substring(0, idx));
                visitorIdMap.put("profileLocation", tntId.substring(idx + 1));
            } else {
                visitorIdMap.put("tntId", tntId);
            }
            String mcid = visitorId.getMarketingCloudVisitorId();
            if (mcid != null) {
                visitorIdMap.put("marketingCloudVisitorId", mcid);
            }
            if ((thirdParty = visitorId.getThirdPartyId()) != null) {
                visitorIdMap.put("thirdPartyId", thirdParty);
            }
            if ((customerIds = visitorId.getCustomerIds()) != null) {
                visitorIdMap.put("customerIds", this.mapper.convertValue(customerIds, Map.class));
            }
            profile.put("visitorId", visitorIdMap);
        }
        return profile;
    }

    private Map<String, Object> requestTrace(TargetDeliveryRequest request, RequestDetails details, boolean execute) {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("sessionId", request.getSessionId());
        req.put("environmentId", request.getDeliveryRequest().getEnvironmentId());
        if (details instanceof ViewRequest) {
            req.put("view", this.mapper.convertValue((Object)details, Map.class));
        } else {
            Map mbox = (Map)this.mapper.convertValue((Object)details, Map.class);
            if (!mbox.containsKey("name")) {
                mbox.put("name", this.ruleSet.getGlobalMbox());
            }
            mbox.put("type", execute ? "execute" : "prefetch");
            req.put("mbox", mbox);
        }
        Address address = details.getAddress();
        if (address != null) {
            String urlStr = address.getUrl();
            req.put("pageURL", address.getUrl());
            try {
                URL url = new URL(urlStr);
                req.put("host", url.getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return req;
    }

    private Map<String, Object> campaignTargetTrace(OnDeviceDecisioningRule rule, Map<String, Object> context) {
        Map<String, Object> target = this.campaignTrace(rule);
        target.put("context", context);
        target.put(MATCHED_IDS_KEY, new ArrayList());
        target.put(UNMATCHED_IDS_KEY, new ArrayList());
        target.put(MATCHED_RULES_KEY, new ArrayList());
        target.put(UNMATCHED_RULES_KEY, new ArrayList());
        return target;
    }

    private Map<String, Object> campaignTrace(OnDeviceDecisioningRule rule) {
        HashMap<String, Object> campaign = new HashMap<String, Object>();
        Map<String, Object> meta = rule.getMeta();
        campaign.put("id", meta.get(ACTIVITY_ID));
        campaign.put("activityName", meta.get(ACTIVITY_NAME));
        campaign.put("activityType", meta.get(ACTIVITY_TYPE));
        return campaign;
    }
}

