/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.ondevice.ClusterLocator;
import com.adobe.target.edge.client.ondevice.DefaultRuleLoader;
import com.adobe.target.edge.client.ondevice.RuleLoader;
import com.adobe.target.edge.client.service.NotificationService;
import com.adobe.target.edge.client.service.TargetService;
import java.util.HashMap;
import java.util.Map;

public class OnDeviceDecisioningServicesManager {
    private static final OnDeviceDecisioningServicesManager sInstance = new OnDeviceDecisioningServicesManager();
    private final Map<String, OnDeviceDecisioningServices> servicesMap = new HashMap<String, OnDeviceDecisioningServices>();

    public static OnDeviceDecisioningServicesManager getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnDeviceDecisioningServices getServices(ClientConfig clientConfig, TargetService targetService) {
        String serviceKey = clientConfig.getClient();
        OnDeviceDecisioningServices services = this.servicesMap.get(serviceKey);
        if (services != null) {
            return services;
        }
        Map<String, OnDeviceDecisioningServices> map = this.servicesMap;
        synchronized (map) {
            services = this.servicesMap.get(serviceKey);
            if (services != null) {
                return services;
            }
            services = new OnDeviceDecisioningServices();
            ClusterLocator clusterLocator = new ClusterLocator();
            services.setNotificationDeliveryService(new NotificationService(targetService, clientConfig, clusterLocator));
            services.setRuleLoader(new DefaultRuleLoader());
            services.setClusterLocator(clusterLocator);
            this.servicesMap.put(serviceKey, services);
            return services;
        }
    }

    public static class OnDeviceDecisioningServices {
        private NotificationService notificationService;
        private RuleLoader ruleLoader;
        private ClusterLocator clusterLocator;

        private void setNotificationDeliveryService(NotificationService notificationService) {
            this.notificationService = notificationService;
        }

        private void setRuleLoader(RuleLoader ruleLoader) {
            this.ruleLoader = ruleLoader;
        }

        private void setClusterLocator(ClusterLocator clusterLocator) {
            this.clusterLocator = clusterLocator;
        }

        public NotificationService getNotificationDeliveryService() {
            return this.notificationService;
        }

        public RuleLoader getRuleLoader() {
            return this.ruleLoader;
        }

        public ClusterLocator getClusterLocator() {
            return this.clusterLocator;
        }
    }
}

