/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.target.edge.client.ondevice;

import com.adobe.target.delivery.v1.model.Context;
import com.adobe.target.delivery.v1.model.DeliveryRequest;
import com.adobe.target.delivery.v1.model.DeliveryResponse;
import com.adobe.target.delivery.v1.model.ExecuteResponse;
import com.adobe.target.delivery.v1.model.Geo;
import com.adobe.target.delivery.v1.model.MboxRequest;
import com.adobe.target.delivery.v1.model.Notification;
import com.adobe.target.delivery.v1.model.PrefetchResponse;
import com.adobe.target.delivery.v1.model.RequestDetails;
import com.adobe.target.delivery.v1.model.ViewRequest;
import com.adobe.target.delivery.v1.model.VisitorId;
import com.adobe.target.edge.client.ClientConfig;
import com.adobe.target.edge.client.http.JacksonObjectMapper;
import com.adobe.target.edge.client.http.ResponseStatus;
import com.adobe.target.edge.client.model.TargetDeliveryRequest;
import com.adobe.target.edge.client.model.TargetDeliveryResponse;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningEvaluation;
import com.adobe.target.edge.client.model.ondevice.OnDeviceDecisioningRuleSet;
import com.adobe.target.edge.client.ondevice.ClusterLocator;
import com.adobe.target.edge.client.ondevice.OnDeviceDecisioningDetailsExecutor;
import com.adobe.target.edge.client.ondevice.OnDeviceDecisioningEvaluator;
import com.adobe.target.edge.client.ondevice.OnDeviceDecisioningServicesManager;
import com.adobe.target.edge.client.ondevice.RuleLoader;
import com.adobe.target.edge.client.ondevice.TraceHandler;
import com.adobe.target.edge.client.ondevice.client.geo.DefaultGeoClient;
import com.adobe.target.edge.client.ondevice.client.geo.GeoClient;
import com.adobe.target.edge.client.ondevice.collator.CustomParamsCollator;
import com.adobe.target.edge.client.ondevice.collator.GeoParamsCollator;
import com.adobe.target.edge.client.ondevice.collator.PageParamsCollator;
import com.adobe.target.edge.client.ondevice.collator.ParamsCollator;
import com.adobe.target.edge.client.ondevice.collator.TimeParamsCollator;
import com.adobe.target.edge.client.ondevice.collator.UserParamsCollator;
import com.adobe.target.edge.client.service.NotificationService;
import com.adobe.target.edge.client.service.TargetService;
import com.adobe.target.edge.client.service.TelemetryService;
import com.adobe.target.edge.client.utils.CookieUtils;
import com.adobe.target.edge.client.utils.StringUtils;
import com.adobe.target.edge.client.utils.TimingTool;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDeviceDecisioningService {
    private static final Logger logger = LoggerFactory.getLogger(OnDeviceDecisioningService.class);
    public static final String CONTEXT_KEY_USER = "user";
    public static final String CONTEXT_KEY_GEO = "geo";
    public static final String CONTEXT_KEY_PAGE = "page";
    public static final String CONTEXT_KEY_REFERRING = "referring";
    public static final String CONTEXT_KEY_CUSTOM = "mbox";
    public static final String TIMING_EXECUTE_REQUEST = "timing_execute_request";
    private static final Map<String, ParamsCollator> REQUEST_PARAMS_COLLATORS = new HashMap<String, ParamsCollator>(){
        {
            this.put(OnDeviceDecisioningService.CONTEXT_KEY_USER, new UserParamsCollator());
            this.put(OnDeviceDecisioningService.CONTEXT_KEY_GEO, new GeoParamsCollator());
        }
    };
    private static final Map<String, ParamsCollator> DETAILS_PARAMS_COLLATORS = new HashMap<String, ParamsCollator>(){
        {
            this.put(OnDeviceDecisioningService.CONTEXT_KEY_PAGE, new PageParamsCollator());
            this.put(OnDeviceDecisioningService.CONTEXT_KEY_REFERRING, new PageParamsCollator(true));
            this.put(OnDeviceDecisioningService.CONTEXT_KEY_CUSTOM, new CustomParamsCollator());
        }
    };
    private final ParamsCollator timeParamsCollator = new TimeParamsCollator();
    private final ClientConfig clientConfig;
    private final ObjectMapper mapper = new JacksonObjectMapper().getMapper();
    private final RuleLoader ruleLoader;
    private final NotificationService notificationService;
    private final TelemetryService telemetryService;
    private final ClusterLocator clusterLocator;
    private final OnDeviceDecisioningDetailsExecutor decisionHandler;
    private final OnDeviceDecisioningEvaluator onDeviceDecisioningEvaluator;
    private final GeoClient geoClient;
    private final Set<String> onDeviceAllMatchingRulesMboxes;

    public OnDeviceDecisioningService(ClientConfig clientConfig, TargetService targetService, TelemetryService telemetryService) {
        this.clientConfig = clientConfig;
        OnDeviceDecisioningServicesManager.OnDeviceDecisioningServices services = OnDeviceDecisioningServicesManager.getInstance().getServices(clientConfig, targetService);
        this.telemetryService = telemetryService;
        this.ruleLoader = services.getRuleLoader();
        this.ruleLoader.start(clientConfig, telemetryService);
        this.notificationService = services.getNotificationDeliveryService();
        this.clusterLocator = services.getClusterLocator();
        this.clusterLocator.start(clientConfig, targetService);
        this.decisionHandler = new OnDeviceDecisioningDetailsExecutor(clientConfig, this.mapper);
        this.onDeviceDecisioningEvaluator = new OnDeviceDecisioningEvaluator(this.ruleLoader);
        this.geoClient = new DefaultGeoClient();
        this.geoClient.start(clientConfig);
        this.onDeviceAllMatchingRulesMboxes = new HashSet<String>();
        List<String> onDeviceAllMatchingRulesMboxes = clientConfig.getOnDeviceAllMatchingRulesMboxes();
        if (onDeviceAllMatchingRulesMboxes != null) {
            this.onDeviceAllMatchingRulesMboxes.addAll(onDeviceAllMatchingRulesMboxes);
        }
    }

    public void stop() {
        this.ruleLoader.stop();
        this.clusterLocator.stop();
    }

    public OnDeviceDecisioningEvaluation evaluateLocalExecution(TargetDeliveryRequest deliveryRequest) {
        return this.onDeviceDecisioningEvaluator.evaluateLocalExecution(deliveryRequest);
    }

    public CompletableFuture<TargetDeliveryResponse> executeRequestAsync(TargetDeliveryRequest deliveryRequest) {
        return CompletableFuture.supplyAsync(() -> this.executeRequest(deliveryRequest));
    }

    public TargetDeliveryResponse executeRequest(TargetDeliveryRequest deliveryRequest) {
        OnDeviceDecisioningRuleSet ruleSet;
        TimingTool timer = new TimingTool();
        timer.timeStart(TIMING_EXECUTE_REQUEST);
        DeliveryRequest delivRequest = deliveryRequest.getDeliveryRequest();
        String requestId = delivRequest.getRequestId();
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        if ((ruleSet = this.ruleLoader.getLatestRules()) == null) {
            DeliveryResponse deliveryResponse = new DeliveryResponse().client(this.clientConfig.getClient()).requestId(requestId).id(delivRequest.getId()).status(503);
            return new TargetDeliveryResponse(deliveryRequest, deliveryResponse, 503, "Local-decisioning rules not available");
        }
        HashMap<String, Object> requestContext = new HashMap<String, Object>(this.timeParamsCollator.collateParams(deliveryRequest, null));
        this.geoLookupIfNeeded(deliveryRequest, ruleSet.isGeoTargetingEnabled());
        this.collateParams(requestContext, REQUEST_PARAMS_COLLATORS, deliveryRequest, null);
        TraceHandler traceHandler = null;
        if (delivRequest.getTrace() != null) {
            traceHandler = new TraceHandler(this.clientConfig, this.ruleLoader, this.mapper, ruleSet, deliveryRequest);
        }
        HashSet<String> responseTokens = new HashSet<String>(ruleSet.getResponseTokens());
        TargetDeliveryResponse targetResponse = this.buildDeliveryResponse(deliveryRequest, requestId);
        String visitorId = this.getOrCreateVisitorId(deliveryRequest, targetResponse);
        List<RequestDetails> prefetchRequests = this.detailsFromPrefetch(delivRequest);
        this.handleDetails(prefetchRequests, requestContext, deliveryRequest, visitorId, responseTokens, traceHandler, ruleSet, targetResponse.getResponse().getPrefetch(), null, null);
        List<RequestDetails> executeRequests = this.detailsFromExecute(delivRequest);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        this.handleDetails(executeRequests, requestContext, deliveryRequest, visitorId, responseTokens, traceHandler, ruleSet, null, targetResponse.getResponse().getExecute(), notifications);
        this.telemetryService.addTelemetry(deliveryRequest, timer, targetResponse);
        this.notificationService.buildNotifications(deliveryRequest, targetResponse, notifications);
        if (this.clientConfig.isLogRequests()) {
            logger.debug(targetResponse.toString());
        }
        return targetResponse;
    }

    private List<RequestDetails> detailsFromPrefetch(DeliveryRequest deliveryRequest) {
        if (deliveryRequest.getPrefetch() != null) {
            ArrayList<RequestDetails> prefetchRequests = new ArrayList<RequestDetails>();
            prefetchRequests.addAll(new ArrayList<MboxRequest>(deliveryRequest.getPrefetch().getMboxes()));
            prefetchRequests.addAll(new ArrayList<ViewRequest>(deliveryRequest.getPrefetch().getViews()));
            if (deliveryRequest.getPrefetch().getPageLoad() != null) {
                prefetchRequests.add(deliveryRequest.getPrefetch().getPageLoad());
            }
            return prefetchRequests;
        }
        return Collections.emptyList();
    }

    private List<RequestDetails> detailsFromExecute(DeliveryRequest deliveryRequest) {
        if (deliveryRequest.getExecute() != null) {
            ArrayList<RequestDetails> executeRequests = new ArrayList<RequestDetails>(new ArrayList<MboxRequest>(deliveryRequest.getExecute().getMboxes()));
            if (deliveryRequest.getExecute().getPageLoad() != null) {
                executeRequests.add(deliveryRequest.getExecute().getPageLoad());
            }
            return executeRequests;
        }
        return Collections.emptyList();
    }

    private TargetDeliveryResponse buildDeliveryResponse(TargetDeliveryRequest deliveryRequest, String requestId) {
        OnDeviceDecisioningEvaluation localEvaluation = this.evaluateLocalExecution(deliveryRequest);
        int status = localEvaluation.isAllLocal() ? 200 : 206;
        DeliveryResponse deliveryResponse = new DeliveryResponse().client(this.clientConfig.getClient()).requestId(requestId).id(deliveryRequest.getDeliveryRequest().getId()).status(status);
        PrefetchResponse prefetchResponse = new PrefetchResponse();
        ExecuteResponse executeResponse = new ExecuteResponse();
        deliveryResponse.setPrefetch(prefetchResponse);
        deliveryResponse.setExecute(executeResponse);
        TargetDeliveryResponse targetResponse = new TargetDeliveryResponse(deliveryRequest, deliveryResponse, status, localEvaluation.isAllLocal() ? "Local-decisioning response" : localEvaluation.getReason());
        ResponseStatus responseStatus = targetResponse.getResponseStatus();
        responseStatus.setGlobalMbox(localEvaluation.getGlobalMbox());
        responseStatus.setRemoteMboxes(localEvaluation.getRemoteMBoxes());
        responseStatus.setRemoteViews(localEvaluation.getRemoteViews());
        return targetResponse;
    }

    private String getOrCreateVisitorId(TargetDeliveryRequest deliveryRequest, TargetDeliveryResponse targetResponse) {
        String vid = null;
        VisitorId visitorId = deliveryRequest.getDeliveryRequest().getId();
        if (visitorId != null) {
            vid = StringUtils.firstNonBlank(visitorId.getMarketingCloudVisitorId(), OnDeviceDecisioningService.removeLocationHint(visitorId.getTntId()), visitorId.getThirdPartyId());
        }
        if (vid == null && targetResponse.getResponse().getId() != null) {
            vid = OnDeviceDecisioningService.removeLocationHint(targetResponse.getResponse().getId().getTntId());
        }
        if (vid != null) {
            return vid;
        }
        String newTntId = this.generateTntId();
        if (visitorId == null) {
            visitorId = new VisitorId().tntId(newTntId);
        } else {
            visitorId.setTntId(newTntId);
        }
        targetResponse.getResponse().setId(visitorId);
        return OnDeviceDecisioningService.removeLocationHint(newTntId);
    }

    private static String removeLocationHint(String tntId) {
        if (StringUtils.isEmpty(tntId)) {
            return tntId;
        }
        int index = tntId.indexOf(".");
        return index <= 0 ? tntId : tntId.substring(0, index);
    }

    private String generateTntId() {
        String tntId = UUID.randomUUID().toString();
        String locationHint = this.clusterLocator.getLocationHint();
        if (locationHint != null) {
            tntId = tntId + "." + CookieUtils.locationHintToNodeDetails(locationHint);
        }
        return tntId;
    }

    private void geoLookupIfNeeded(TargetDeliveryRequest deliveryRequest, boolean doGeoLookup) {
        Geo geo;
        if (!doGeoLookup) {
            return;
        }
        Context context = deliveryRequest.getDeliveryRequest().getContext();
        if (context != null && (geo = context.getGeo()) != null && StringUtils.isNotEmpty(geo.getIpAddress()) && StringUtils.isEmpty(geo.getCity()) && StringUtils.isEmpty(geo.getStateCode()) && StringUtils.isEmpty(geo.getCountryCode()) && geo.getLatitude() == null && geo.getLongitude() == null) {
            Geo resolvedGeo = this.geoClient.lookupGeo(geo.getIpAddress());
            deliveryRequest.getDeliveryRequest().getContext().setGeo(resolvedGeo);
        }
    }

    private void collateParams(Map<String, Object> localContext, Map<String, ParamsCollator> paramsCollator, TargetDeliveryRequest deliveryRequest, RequestDetails requestDetails) {
        for (Map.Entry<String, ParamsCollator> entry : paramsCollator.entrySet()) {
            localContext.put(entry.getKey(), entry.getValue().collateParams(deliveryRequest, requestDetails));
        }
    }

    private void handleDetails(List<RequestDetails> detailsList, Map<String, Object> requestContext, TargetDeliveryRequest deliveryRequest, String visitorId, Set<String> responseTokens, TraceHandler traceHandler, OnDeviceDecisioningRuleSet ruleSet, PrefetchResponse prefetchResponse, ExecuteResponse executeResponse, List<Notification> notifications) {
        for (RequestDetails details : detailsList) {
            HashMap<String, Object> detailsContext = new HashMap<String, Object>(requestContext);
            this.collateParams(detailsContext, DETAILS_PARAMS_COLLATORS, deliveryRequest, details);
            this.decisionHandler.executeDetails(deliveryRequest, this.onDeviceAllMatchingRulesMboxes, detailsContext, visitorId, responseTokens, traceHandler, ruleSet, details, prefetchResponse, executeResponse, notifications);
        }
    }
}

